/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.displayer.gauge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.displayer.AbstractDataDisplayerRenderer;
import org.jboss.dashboard.displayer.DataDisplayer;
import org.jboss.dashboard.displayer.DataDisplayerFeature;
import org.jboss.dashboard.displayer.DataDisplayerType;
import org.jboss.dashboard.displayer.annotation.MeterChart;

@Install
@MeterChart
public class GaugeDisplayerRenderer
extends AbstractDataDisplayerRenderer {
    public static final String UID = "gauge";
    @Inject
    @Config(value="gauge")
    protected String uid;
    @Inject
    @Config(value="meter")
    public String[] meterChartTypes;
    @Inject
    @Config(value="meter")
    public String meterChartDefault;
    List<DataDisplayerFeature> featuresSupported;
    Map<String, List<String>> availableChartTypes;
    Map<String, String> defaultChartTypes;

    public String getUid() {
        return this.uid;
    }

    public String getDescription(Locale l) {
        try {
            ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.displayer.gauge.messages", l);
            return i18n.getString("gauge.name");
        }
        catch (Exception e) {
            return "Gauge";
        }
    }

    public boolean isFeatureSupported(DataDisplayer displayer, DataDisplayerFeature feature) {
        return this.featuresSupported.contains(feature);
    }

    public List<String> getAvailableChartTypes(DataDisplayer displayer) {
        DataDisplayerType displayerType = displayer.getDataDisplayerType();
        return this.availableChartTypes.get(displayerType.getUid());
    }

    public String getDefaultChartType(DataDisplayer displayer) {
        DataDisplayerType displayerType = displayer.getDataDisplayerType();
        return this.defaultChartTypes.get(displayerType.getUid());
    }

    public String getChartTypeDescription(String chartType, Locale locale) {
        try {
            ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.displayer.gauge.messages", locale);
            return i18n.getString("gauge.type." + chartType);
        }
        catch (Exception e) {
            return chartType;
        }
    }

    @PostConstruct
    public void init() {
        this.featuresSupported = new ArrayList<DataDisplayerFeature>();
        this.featuresSupported.add(DataDisplayerFeature.ALIGN_CHART);
        this.featuresSupported.add(DataDisplayerFeature.SHOW_TITLE);
        this.featuresSupported.add(DataDisplayerFeature.SHOW_LEGEND_POSITION);
        this.featuresSupported.add(DataDisplayerFeature.ROUND_TO_INTEGER);
        this.featuresSupported.add(DataDisplayerFeature.SET_FOREGRND_COLOR);
        this.featuresSupported.add(DataDisplayerFeature.SET_CHART_TYPE);
        this.availableChartTypes = new HashMap<String, List<String>>();
        this.availableChartTypes.put("meterchart", Arrays.asList(this.meterChartTypes));
        this.defaultChartTypes = new HashMap<String, String>();
        this.defaultChartTypes.put("meterchart", this.meterChartDefault);
    }
}

