/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.displayer.ofc2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.displayer.AbstractDataDisplayerRenderer;
import org.jboss.dashboard.displayer.DataDisplayer;
import org.jboss.dashboard.displayer.DataDisplayerFeature;
import org.jboss.dashboard.displayer.DataDisplayerType;
import org.jboss.dashboard.displayer.annotation.BarChart;
import org.jboss.dashboard.displayer.annotation.LineChart;
import org.jboss.dashboard.displayer.annotation.PieChart;
import org.jboss.dashboard.displayer.chart.AbstractXAxisDisplayer;

@Install
@BarChart
@PieChart
@LineChart
public class OFC2DisplayerRenderer
extends AbstractDataDisplayerRenderer {
    public static final String UID = "ofc2";
    @Inject
    @Config(value="ofc2")
    protected String uid;
    @Inject
    @Config(value="bar_glass, bar, bar_3d, bar_filled, bar_cylinder, bar_round, bar_sketch")
    public String[] barChartTypes;
    @Inject
    @Config(value="bar_filled")
    public String barChartDefault;
    @Inject
    @Config(value="pie")
    public String[] pieChartTypes;
    @Inject
    @Config(value="pie")
    public String pieChartDefault;
    @Inject
    @Config(value="line")
    public String[] lineChartTypes;
    @Inject
    @Config(value="line")
    public String lineChartDefault;
    List<DataDisplayerFeature> featuresSupported;
    Map<String, List<String>> availableChartTypes;
    Map<String, String> defaultChartTypes;
    @Inject
    protected LocaleManager localeManager;

    @PostConstruct
    protected void init() {
        this.featuresSupported = new ArrayList<DataDisplayerFeature>();
        this.featuresSupported.add(DataDisplayerFeature.ALIGN_CHART);
        this.featuresSupported.add(DataDisplayerFeature.SHOW_TITLE);
        this.featuresSupported.add(DataDisplayerFeature.SHOW_HIDE_LABELS);
        this.featuresSupported.add(DataDisplayerFeature.ROUND_TO_INTEGER);
        this.featuresSupported.add(DataDisplayerFeature.SET_CHART_WIDTH);
        this.featuresSupported.add(DataDisplayerFeature.SET_CHART_HEIGHT);
        this.featuresSupported.add(DataDisplayerFeature.SET_FOREGRND_COLOR);
        this.featuresSupported.add(DataDisplayerFeature.SET_LABELS_ANGLE);
        this.availableChartTypes = new HashMap<String, List<String>>();
        this.availableChartTypes.put("barchart", Arrays.asList(this.barChartTypes));
        this.availableChartTypes.put("piechart", Arrays.asList(this.pieChartTypes));
        this.availableChartTypes.put("linechart", Arrays.asList(this.lineChartTypes));
        this.defaultChartTypes = new HashMap<String, String>();
        this.defaultChartTypes.put("barchart", this.barChartDefault);
        this.defaultChartTypes.put("piechart", this.pieChartDefault);
        this.defaultChartTypes.put("linechart", this.lineChartDefault);
    }

    public String getUid() {
        return this.uid;
    }

    public String getDescription(Locale l) {
        try {
            ResourceBundle i18n = this.localeManager.getBundle("org.jboss.dashboard.displayer.ofc2.messages", l);
            return i18n.getString("ofc2.name");
        }
        catch (Exception e) {
            return "Open Flash Chart 2";
        }
    }

    public boolean isFeatureSupported(DataDisplayer displayer, DataDisplayerFeature feature) {
        if (DataDisplayerFeature.SET_CHART_TYPE == feature) {
            return displayer.getDataDisplayerType().getUid().equals("barchart");
        }
        return this.featuresSupported.contains(feature);
    }

    public List<String> getAvailableChartTypes(DataDisplayer displayer) {
        DataDisplayerType displayerType = displayer.getDataDisplayerType();
        return this.availableChartTypes.get(displayerType.getUid());
    }

    public String getDefaultChartType(DataDisplayer displayer) {
        DataDisplayerType displayerType = displayer.getDataDisplayerType();
        return this.defaultChartTypes.get(displayerType.getUid());
    }

    public String getChartTypeDescription(String chartType, Locale locale) {
        try {
            ResourceBundle i18n = this.localeManager.getBundle("org.jboss.dashboard.displayer.ofc2.messages", locale);
            return i18n.getString("ofc2.type." + chartType);
        }
        catch (Exception e) {
            return chartType;
        }
    }

    public void setDefaultSettings(DataDisplayer displayer) {
        if (displayer instanceof AbstractXAxisDisplayer) {
            AbstractXAxisDisplayer xAxisDisplayer = (AbstractXAxisDisplayer)displayer;
            xAxisDisplayer.setLabelAngleXAxis(-45);
        }
    }
}

