/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.toolkit.factory;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.dashboard.toolkit.factory.ConfigValueWriter;
import org.jboss.dashboard.toolkit.factory.util.TextConverterFunction;

public class ConfigFactory {
    private String factoryPath;
    private String propertyFile;
    private ArrayList<String> ignoredPrefixes = new ArrayList();

    public ConfigFactory(String propertyFile, String factoryPath) {
        this(propertyFile, factoryPath, null);
    }

    public ConfigFactory(String propertyFile, String factoryPath, String ignoredPrefixesList) {
        this.factoryPath = factoryPath;
        this.propertyFile = propertyFile;
        if (ignoredPrefixesList != null) {
            StringTokenizer tokenizer = new StringTokenizer(ignoredPrefixesList, ",");
            while (tokenizer.hasMoreTokens()) {
                String ignoredPrefix = tokenizer.nextToken().trim();
                this.ignoredPrefixes.add(ignoredPrefix);
            }
        }
    }

    public void modifyConfiguration() throws IOException {
        this.processPropertiesFile(this.propertyFile);
    }

    private void processPropertiesFile(String filePath) throws IOException {
        FileInputStream fis = new FileInputStream(filePath);
        Properties props = new Properties();
        props.load(fis);
        fis.close();
        Set<Object> properties = props.keySet();
        for (String string : properties) {
            String propertyValue = props.getProperty(string);
            if (!this.isFactoryProperty(string)) continue;
            this.processConfigValue(string, propertyValue);
        }
    }

    public boolean isFactoryProperty(String propertyName) {
        Iterator<String> it = this.ignoredPrefixes.iterator();
        while (it.hasNext()) {
            if (!propertyName.startsWith(it.next())) continue;
            return false;
        }
        return true;
    }

    public void processConfigValue(String propertyName, String propertyValue) throws IOException {
        boolean usingFunction;
        int openParPos = propertyValue.indexOf(40);
        int closeParPos = propertyValue.indexOf(41);
        boolean bl = usingFunction = openParPos > 0 && closeParPos > 0 && closeParPos > openParPos;
        if (usingFunction) {
            String functionName = propertyValue.substring(0, openParPos);
            String functionArg = propertyValue.substring(openParPos + 1, closeParPos);
            propertyValue = this.evaluateConverterFunction(functionName, functionArg);
        }
        new ConfigValueWriter(this.factoryPath).writeProperty(propertyName, propertyValue);
    }

    protected String evaluateConverterFunction(String functionName, String functionArg) {
        String className = this.getClass().getPackage().getName() + ".util." + functionName;
        try {
            TextConverterFunction function = (TextConverterFunction)Class.forName(className).newInstance();
            return function.convertValue(functionArg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return functionArg;
        }
    }

    public void modifyComponent(String componentPath, Properties propsToSave) throws IOException {
        new ConfigValueWriter(this.factoryPath).writePropertiesToComponent(componentPath, propsToSave);
    }

    public boolean existsCustomConfigForComponent(String component) {
        return new ConfigValueWriter(this.factoryPath).existsComponent(component);
    }

    public String getConfigurationValue(String path) throws IOException {
        return new ConfigValueWriter(this.factoryPath).readProperty(path);
    }

    public String getFactoryPath() {
        return this.factoryPath;
    }

    public void setFactoryPath(String factoryPath) {
        this.factoryPath = factoryPath;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }
}

