/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.toolkit.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.jboss.dashboard.toolkit.factory.ConfigWriter;

public class ConfigValueWriter
extends ConfigWriter {
    public ConfigValueWriter(String factoryPath) {
        super(factoryPath, factoryPath + "/etc/extras/comments");
    }

    protected ConfigValueWriter(String factoryPath, String commentsPath) {
        super(factoryPath, commentsPath);
    }

    public void writeProperty(String factoryPropertyPath, String value) throws IOException {
        int propertyStart = factoryPropertyPath.lastIndexOf("/");
        String factoryComponent = factoryPropertyPath.substring(0, propertyStart);
        String propName = factoryPropertyPath.substring(propertyStart + 1, factoryPropertyPath.length());
        Properties props = new Properties();
        props.setProperty(propName, value);
        this.writePropertiesToComponent(factoryComponent, props);
    }

    public String readProperty(String factoryPropertyPath) throws IOException {
        int propertyStart = factoryPropertyPath.lastIndexOf("/");
        String factoryComponent = factoryPropertyPath.substring(0, propertyStart);
        String propName = factoryPropertyPath.substring(propertyStart + 1, factoryPropertyPath.length());
        File propertiesFileToRead = this.getPropertiesFilePath(factoryComponent);
        Properties existingProperties = new Properties();
        if (propertiesFileToRead.exists()) {
            FileInputStream fis = new FileInputStream(propertiesFileToRead);
            existingProperties.load(fis);
            fis.close();
            return existingProperties.getProperty(propName);
        }
        return null;
    }
}

