/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.toolkit.factory;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.util.StringUtils;

public abstract class ConfigWriter {
    public static final String PROPERTY_SEPARATOR = "/";
    private String factoryPath;
    private String commentsPath;

    protected ConfigWriter(String appPath, String commentsPath) {
        this.factoryPath = appPath;
        this.commentsPath = commentsPath;
    }

    protected File getPropertiesFilePath(String componentName) {
        componentName = StringUtils.replace((String)componentName, (String)".", (String)PROPERTY_SEPARATOR);
        File propertiesFileToModify = new File(this.factoryPath + PROPERTY_SEPARATOR + componentName + ".factory");
        return propertiesFileToModify;
    }

    public boolean existsComponent(String component) {
        return this.getPropertiesFilePath(component).exists();
    }

    protected void writePropertiesToComponent(String componentName, Properties values) throws IOException {
        File propertiesFileToModify = this.getPropertiesFilePath(componentName);
        Properties existingProperties = new Properties();
        File parentDirectory = propertiesFileToModify.getParentFile();
        if (!parentDirectory.exists()) {
            this.createDirectoryPath(parentDirectory);
        }
        if (propertiesFileToModify.exists()) {
            FileInputStream fis = new FileInputStream(propertiesFileToModify);
            existingProperties.load(fis);
            fis.close();
        }
        existingProperties.putAll((Map<?, ?>)values);
        FileOutputStream fos = new FileOutputStream(propertiesFileToModify);
        this.writeCommentsToStream(componentName, fos);
        existingProperties.store(fos, "");
        fos.close();
    }

    private void createDirectoryPath(File directory) throws IOException {
        if (directory != null && !directory.exists()) {
            File parentDirectory = directory.getParentFile();
            if (parentDirectory != null) {
                this.createDirectoryPath(parentDirectory);
            }
            directory.mkdir();
        }
    }

    private void writeCommentsToStream(String componentName, FileOutputStream fos) throws IOException {
        File commentsFile = new File(this.commentsPath + PROPERTY_SEPARATOR + componentName + ".txt");
        if (commentsFile.exists()) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(commentsFile));
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    fos.write("\n#".getBytes());
                } else {
                    first = false;
                }
                fos.write(line.getBytes());
            }
            reader.close();
        }
    }
}

