/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.toolkit.factory.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.dashboard.toolkit.factory.util.TextConverterFunction;
import sun.misc.CRC16;

public class Hash
extends TextConverterFunction {
    @Override
    public String convertValue(String value) {
        if (value == null || "".equals(value)) {
            return "";
        }
        return this.digestPassword(value);
    }

    public String digestPassword(String password) {
        try {
            if (password == null || "".equals(password)) {
                return "";
            }
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] shaPassword = md.digest(password.getBytes());
            CRC16 crcCalculator = new CRC16();
            for (int i = 0; i < shaPassword.length; ++i) {
                byte cipheredByte = shaPassword[i];
                crcCalculator.update(cipheredByte);
            }
            crcCalculator.update((byte)105);
            byte[] cipheredAndCRCBytes = new byte[shaPassword.length + 2];
            System.arraycopy(shaPassword, 0, cipheredAndCRCBytes, 0, shaPassword.length);
            cipheredAndCRCBytes[cipheredAndCRCBytes.length - 2] = (byte)(crcCalculator.value >> 8);
            cipheredAndCRCBytes[cipheredAndCRCBytes.length - 1] = (byte)(crcCalculator.value & 0xFF);
            return Hash.encode(cipheredAndCRCBytes);
        }
        catch (NoSuchAlgorithmException e) {
            return password;
        }
    }

    public static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < raw.length; i += 3) {
            encoded.append(Hash.encodeBlock(raw, i));
        }
        return encoded.toString();
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        for (int i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
        }
        char[] base64 = new char[4];
        for (int i = 0; i < 4; ++i) {
            int sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = Hash.getChar(sixbit);
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    protected static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }
}

