/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm.riverslist;

import java.io.IOException;
import java.util.HashSet;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.jboss.elasticsearch.river.jira.mgm.RestJRMgmBaseAction;
import org.jboss.elasticsearch.river.jira.mgm.riverslist.ListRiversAction;
import org.jboss.elasticsearch.river.jira.mgm.riverslist.ListRiversRequest;
import org.jboss.elasticsearch.river.jira.mgm.riverslist.ListRiversResponse;
import org.jboss.elasticsearch.river.jira.mgm.riverslist.NodeListRiversResponse;

public class RestListRiversAction
extends RestJRMgmBaseAction {
    @Inject
    protected RestListRiversAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_jira_river/list", (RestHandler)this);
    }

    public void handleRequest(final RestRequest restRequest, final RestChannel restChannel) {
        ListRiversRequest actionRequest = new ListRiversRequest();
        this.logger.debug("Go to look for jira rivers in cluster", new Object[0]);
        this.client.execute((Action)ListRiversAction.INSTANCE, (ActionRequest)actionRequest, (ActionListener)new ActionListener<ListRiversResponse>(){

            public void onResponse(ListRiversResponse response) {
                try {
                    HashSet<String> allRivers = new HashSet<String>();
                    for (NodeListRiversResponse node : (NodeListRiversResponse[])response.nodes()) {
                        if (node.jiraRiverNames == null) continue;
                        allRivers.addAll(node.jiraRiverNames);
                    }
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder((RestRequest)restRequest);
                    builder.startObject();
                    builder.field("jira_river_names", allRivers);
                    builder.endObject();
                    restChannel.sendResponse((RestResponse)new XContentRestResponse(restRequest, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Throwable e) {
                try {
                    restChannel.sendResponse((RestResponse)new XContentThrowableRestResponse(restRequest, e));
                }
                catch (IOException e1) {
                    RestListRiversAction.this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
                }
            }
        });
    }
}

