/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.jboss.elasticsearch.river.jira.IESIntegration;
import org.jboss.elasticsearch.river.jira.IJIRAClient;
import org.jboss.elasticsearch.river.jira.IJIRAIssueIndexStructureBuilder;
import org.jboss.elasticsearch.river.jira.IJIRAProjectIndexerCoordinator;
import org.jboss.elasticsearch.river.jira.JIRAProjectIndexer;
import org.jboss.elasticsearch.river.jira.ProjectIndexingInfo;

public class JIRAProjectIndexerCoordinator
implements IJIRAProjectIndexerCoordinator {
    private static final ESLogger logger = Loggers.getLogger(JIRAProjectIndexerCoordinator.class);
    protected static final String STORE_PROPERTYNAME_LAST_INDEX_UPDATE_START_DATE = "lastIndexUpdateStartDate";
    protected static final String STORE_PROPERTYNAME_LAST_INDEX_FULL_UPDATE_DATE = "lastIndexFullUpdateDate";
    protected static final String STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE = "forceIndexFullUpdateDate";
    protected static final int COORDINATOR_THREAD_WAITS_QUICK = 2000;
    protected static final int COORDINATOR_THREAD_WAITS_SLOW = 30000;
    protected int coordinatorThreadWaits = 2000;
    protected IESIntegration esIntegrationComponent;
    protected IJIRAClient jiraClient;
    protected IJIRAIssueIndexStructureBuilder jiraIssueIndexStructureBuilder;
    protected int maxIndexingThreads;
    protected long indexUpdatePeriod;
    protected long indexFullUpdatePeriod = -1L;
    protected Queue<String> projectKeysToIndexQueue = new LinkedBlockingQueue<String>();
    protected final Map<String, Thread> projectIndexerThreads = new HashMap<String, Thread>();
    protected final Map<String, JIRAProjectIndexer> projectIndexers = new HashMap<String, JIRAProjectIndexer>();
    protected long lastQueueFillTime = 0L;

    public JIRAProjectIndexerCoordinator(IJIRAClient jiraClient, IESIntegration esIntegrationComponent, IJIRAIssueIndexStructureBuilder jiraIssueIndexStructureBuilder, long indexUpdatePeriod, int maxIndexingThreads, long indexFullUpdatePeriod) {
        this.jiraClient = jiraClient;
        this.esIntegrationComponent = esIntegrationComponent;
        this.indexUpdatePeriod = indexUpdatePeriod;
        this.maxIndexingThreads = maxIndexingThreads;
        this.jiraIssueIndexStructureBuilder = jiraIssueIndexStructureBuilder;
        this.indexFullUpdatePeriod = indexFullUpdatePeriod;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void processLoopTask() throws Exception, InterruptedException {
        long now = System.currentTimeMillis();
        if (this.projectKeysToIndexQueue.isEmpty() || this.lastQueueFillTime < now - 30000L) {
            this.lastQueueFillTime = now;
            this.fillProjectKeysToIndexQueue();
        }
        if (this.projectKeysToIndexQueue.isEmpty()) {
            this.coordinatorThreadWaits = 30000;
        } else {
            this.coordinatorThreadWaits = 2000;
            this.startIndexers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillProjectKeysToIndexQueue() throws Exception, InterruptedException {
        List<String> ap = this.esIntegrationComponent.getAllIndexedProjectsKeys();
        if (ap != null && !ap.isEmpty()) {
            for (String projectKey : ap) {
                if (this.esIntegrationComponent.isClosed()) {
                    throw new InterruptedException();
                }
                Map<String, Thread> map = this.projectIndexerThreads;
                synchronized (map) {
                    if (this.projectIndexerThreads.containsKey(projectKey)) {
                        continue;
                    }
                }
                if (this.projectKeysToIndexQueue.contains(projectKey) || !this.projectIndexUpdateNecessary(projectKey)) continue;
                this.projectKeysToIndexQueue.add(projectKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startIndexers() throws InterruptedException, Exception {
        String firstSkippedFullIndex = null;
        while (this.projectIndexerThreads.size() < this.maxIndexingThreads && !this.projectKeysToIndexQueue.isEmpty()) {
            if (this.esIntegrationComponent.isClosed()) {
                throw new InterruptedException();
            }
            String projectKey = this.projectKeysToIndexQueue.poll();
            boolean fullUpdateNecessary = this.projectIndexFullUpdateNecessary(projectKey);
            if (fullUpdateNecessary && this.maxIndexingThreads > 1 && this.projectIndexerThreads.size() == this.maxIndexingThreads - 1) {
                this.projectKeysToIndexQueue.add(projectKey);
                if (firstSkippedFullIndex == null) {
                    firstSkippedFullIndex = projectKey;
                    continue;
                }
                if (firstSkippedFullIndex != projectKey) continue;
                return;
            }
            JIRAProjectIndexer indexer = new JIRAProjectIndexer(projectKey, fullUpdateNecessary, this.jiraClient, this.esIntegrationComponent, this.jiraIssueIndexStructureBuilder);
            Thread it = this.esIntegrationComponent.acquireIndexingThread("jira_river_indexer_" + projectKey, indexer);
            this.esIntegrationComponent.storeDatetimeValue(projectKey, STORE_PROPERTYNAME_LAST_INDEX_UPDATE_START_DATE, new Date(), null);
            Map<String, Thread> map = this.projectIndexerThreads;
            synchronized (map) {
                this.projectIndexerThreads.put(projectKey, it);
                this.projectIndexers.put(projectKey, indexer);
            }
            it.start();
        }
    }

    protected boolean projectIndexUpdateNecessary(String projectKey) throws Exception {
        Date lastIndexing = this.esIntegrationComponent.readDatetimeValue(projectKey, STORE_PROPERTYNAME_LAST_INDEX_UPDATE_START_DATE);
        if (logger.isDebugEnabled()) {
            logger.debug("Project {} last indexing start date is {}. We perform next indexing after {}ms.", new Object[]{projectKey, lastIndexing, this.indexUpdatePeriod});
        }
        return lastIndexing == null || lastIndexing.getTime() < System.currentTimeMillis() - this.indexUpdatePeriod;
    }

    protected boolean projectIndexFullUpdateNecessary(String projectKey) throws Exception {
        if (this.esIntegrationComponent.readDatetimeValue(projectKey, STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE) != null) {
            return true;
        }
        if (this.indexFullUpdatePeriod < 1L) {
            return false;
        }
        Date lastIndexing = this.esIntegrationComponent.readDatetimeValue(projectKey, STORE_PROPERTYNAME_LAST_INDEX_FULL_UPDATE_DATE);
        if (logger.isDebugEnabled()) {
            logger.debug("Project {} last full update date is {}. We perform next full indexing after {}ms.", new Object[]{projectKey, lastIndexing, this.indexFullUpdatePeriod});
        }
        return lastIndexing == null || lastIndexing.getTime() < System.currentTimeMillis() - this.indexFullUpdatePeriod;
    }

    @Override
    public void forceFullReindex(String projectKey) throws Exception {
        this.esIntegrationComponent.storeDatetimeValue(projectKey, STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE, new Date(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportIndexingFinished(String jiraProjectKey, boolean finishedOK, boolean fullUpdate) {
        Map<String, Thread> map = this.projectIndexerThreads;
        synchronized (map) {
            this.projectIndexerThreads.remove(jiraProjectKey);
            this.projectIndexers.remove(jiraProjectKey);
        }
        if (finishedOK && fullUpdate) {
            try {
                this.esIntegrationComponent.storeDatetimeValue(jiraProjectKey, STORE_PROPERTYNAME_LAST_INDEX_FULL_UPDATE_DATE, new Date(), null);
            }
            catch (Exception e) {
                logger.error("Can't store {} value due: {}", new Object[]{STORE_PROPERTYNAME_LAST_INDEX_FULL_UPDATE_DATE, e.getMessage()});
            }
            try {
                this.esIntegrationComponent.deleteDatetimeValue(jiraProjectKey, STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE);
            }
            catch (Exception e) {
                logger.error("Can't store {} value due: {}", new Object[]{STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE, e.getMessage()});
            }
        }
    }

    public void setIndexFullUpdatePeriod(int indexFullUpdatePeriod) {
        this.indexFullUpdatePeriod = indexFullUpdatePeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProjectIndexingInfo> getCurrentProjectIndexingInfo() {
        ArrayList<ProjectIndexingInfo> ret = new ArrayList<ProjectIndexingInfo>();
        Map<String, Thread> map = this.projectIndexerThreads;
        synchronized (map) {
            for (JIRAProjectIndexer indexer : this.projectIndexers.values()) {
                ret.add(indexer.getIndexingInfo());
            }
        }
        return ret;
    }
}

