/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class AddValuePreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_FIELD = "field";
    protected static final String CFG_VALUE = "value";
    protected String field;
    protected Object value = null;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.field = XContentMapValues.nodeStringValue((Object)settings.get(CFG_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.field, CFG_FIELD);
        this.value = settings.get(CFG_VALUE);
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data, PreprocessChainContext context) {
        if (data == null) {
            return null;
        }
        if (this.value != null && this.value instanceof String && ((String)this.value).contains("{")) {
            this.value = ValueUtils.processStringValuePatternReplacement((String)this.value, data, null);
        }
        StructureUtils.putValueIntoMapOfMaps(data, this.field, this.value);
        return data;
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }
}

