/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;

public class ScriptingPreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_SCRIPT_ENGINE_NAME_FIELD = "script_engine_name";
    protected static final String CFG_SCRIPT_FIELD = "script";
    protected String scriptEngineName;
    protected static ScriptEngineManager factory = new ScriptEngineManager();
    protected String script;
    protected ScriptEngine engine;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.script = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SCRIPT_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.script, CFG_SCRIPT_FIELD);
        this.scriptEngineName = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SCRIPT_ENGINE_NAME_FIELD), (String)"JavaScript");
        this.validateConfigurationStringNotEmpty(this.scriptEngineName, CFG_SCRIPT_ENGINE_NAME_FIELD);
        this.engine = factory.getEngineByName(this.scriptEngineName);
        if (this.engine == null) {
            throw new SettingsException("No scripting engine is available for name " + this.scriptEngineName + " for preprocessor " + this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data, PreprocessChainContext chainContext) {
        SimpleScriptContext newContext = new SimpleScriptContext();
        Bindings engineScope = newContext.getBindings(100);
        engineScope.put("data", (Object)data);
        try {
            ScriptEngine scriptEngine = this.engine;
            synchronized (scriptEngine) {
                this.engine.eval(this.script, (ScriptContext)newContext);
            }
        }
        catch (ScriptException e) {
            String warningMessage = "Script execution failed: " + e.getMessage();
            this.addDataWarning(chainContext, warningMessage);
            this.logger.debug(warningMessage, new Object[0]);
        }
        return data;
    }

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public String getScript() {
        return this.script;
    }
}

