/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.search.SearchHit;
import org.jboss.elasticsearch.river.jira.ChangedIssuesResults;
import org.jboss.elasticsearch.river.jira.DateTimeUtils;
import org.jboss.elasticsearch.river.jira.IESIntegration;
import org.jboss.elasticsearch.river.jira.IJIRAClient;
import org.jboss.elasticsearch.river.jira.IJIRAIssueIndexStructureBuilder;
import org.jboss.elasticsearch.river.jira.ProjectIndexingInfo;

public class JIRAProjectIndexer
implements Runnable {
    private ESLogger logger = Loggers.getLogger(JIRAProjectIndexer.class);
    protected static final String STORE_PROPERTYNAME_LAST_INDEXED_ISSUE_UPDATE_DATE = "lastIndexedIssueUpdateDate";
    protected final IJIRAClient jiraClient;
    protected final IESIntegration esIntegrationComponent;
    protected final IJIRAIssueIndexStructureBuilder jiraIssueIndexStructureBuilder;
    protected final String projectKey;
    protected long startTime = 0L;
    protected ProjectIndexingInfo indexingInfo;

    public JIRAProjectIndexer(String projectKey, boolean fullUpdate, IJIRAClient jiraClient, IESIntegration esIntegrationComponent, IJIRAIssueIndexStructureBuilder jiraIssueIndexStructureBuilder) {
        if (projectKey == null || projectKey.trim().length() == 0) {
            throw new IllegalArgumentException("projectKey must be defined");
        }
        this.logger = esIntegrationComponent.createLogger(this.getClass());
        this.jiraClient = jiraClient;
        this.projectKey = projectKey;
        this.esIntegrationComponent = esIntegrationComponent;
        this.jiraIssueIndexStructureBuilder = jiraIssueIndexStructureBuilder;
        this.indexingInfo = new ProjectIndexingInfo(projectKey, fullUpdate);
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        this.indexingInfo.startDate = new Date(this.startTime);
        try {
            this.processUpdate();
            this.processDelete(new Date(this.startTime));
            this.indexingInfo.timeElapsed = System.currentTimeMillis() - this.startTime;
            this.indexingInfo.finishedOK = true;
            this.esIntegrationComponent.reportIndexingFinished(this.indexingInfo);
            this.logger.info("Finished {} update for JIRA project {}. {} updated and {} deleted issues. Time elapsed {}s.", new Object[]{this.indexingInfo.fullUpdate ? "full" : "incremental", this.projectKey, this.indexingInfo.issuesUpdated, this.indexingInfo.issuesDeleted, this.indexingInfo.timeElapsed / 1000L});
        }
        catch (Throwable e) {
            this.indexingInfo.timeElapsed = System.currentTimeMillis() - this.startTime;
            this.indexingInfo.errorMessage = e.getMessage();
            this.indexingInfo.finishedOK = false;
            this.esIntegrationComponent.reportIndexingFinished(this.indexingInfo);
            Throwable cause = e;
            if ((cause instanceof IOException || cause instanceof InterruptedException) && cause.getMessage() != null) {
                cause = null;
            }
            this.logger.error("Failed {} update for JIRA project {} due: {}", cause, new Object[]{this.indexingInfo.fullUpdate ? "full" : "incremental", this.projectKey, e.getMessage()});
        }
    }

    protected void processUpdate() throws Exception {
        this.indexingInfo.issuesUpdated = 0;
        Date updatedAfter = null;
        if (!this.indexingInfo.fullUpdate) {
            updatedAfter = DateTimeUtils.roundDateTimeToMinutePrecise(this.readLastIssueUpdatedDate(this.projectKey));
        }
        Date updatedAfterStarting = updatedAfter;
        if (updatedAfter == null) {
            this.indexingInfo.fullUpdate = true;
        }
        Date lastIssueUpdatedDate = null;
        int startAt = 0;
        this.logger.info("Go to perform {} update for JIRA project {}", new Object[]{this.indexingInfo.fullUpdate ? "full" : "incremental", this.projectKey});
        boolean cont = true;
        while (cont) {
            ChangedIssuesResults res;
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Go to ask for updated JIRA issues for project {} with startAt {} updated {}", new Object[]{this.projectKey, startAt, updatedAfter != null ? "after " + updatedAfter : "in whole history"});
            }
            if ((res = this.jiraClient.getJIRAChangedIssues(this.projectKey, startAt, updatedAfter, null)).getIssuesCount() == 0) {
                cont = false;
                continue;
            }
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            Date firstIssueUpdatedDate = null;
            BulkRequestBuilder esBulk = this.esIntegrationComponent.prepareESBulkRequestBuilder();
            for (Map<String, Object> issue : res.getIssues()) {
                String issueKey = this.jiraIssueIndexStructureBuilder.extractIssueKey(issue);
                if (issueKey == null) {
                    throw new IllegalArgumentException("Issue 'key' field not found in JIRA response for project " + this.projectKey + " within issue data: " + issue);
                }
                lastIssueUpdatedDate = DateTimeUtils.roundDateTimeToMinutePrecise(this.jiraIssueIndexStructureBuilder.extractIssueUpdated(issue));
                this.logger.debug("Go to update index for issue {} with updated {}", new Object[]{issueKey, lastIssueUpdatedDate});
                if (lastIssueUpdatedDate == null) {
                    throw new IllegalArgumentException("'updated' field not found in JIRA response data for issue " + issueKey);
                }
                if (firstIssueUpdatedDate == null) {
                    firstIssueUpdatedDate = lastIssueUpdatedDate;
                }
                this.jiraIssueIndexStructureBuilder.indexIssue(esBulk, this.projectKey, issue);
                ++this.indexingInfo.issuesUpdated;
                if (!this.isClosed()) continue;
                throw new InterruptedException("Interrupted because River is closed");
            }
            this.storeLastIssueUpdatedDate(esBulk, this.projectKey, lastIssueUpdatedDate);
            this.esIntegrationComponent.executeESBulkRequest(esBulk);
            if (!lastIssueUpdatedDate.equals(firstIssueUpdatedDate)) {
                updatedAfter = lastIssueUpdatedDate;
                cont = res.getTotal() > res.getStartAt() + res.getIssuesCount();
                startAt = 0;
                continue;
            }
            startAt = res.getStartAt() + res.getIssuesCount();
            cont = res.getTotal() > startAt;
        }
        if (this.indexingInfo.issuesUpdated > 0 && lastIssueUpdatedDate != null && updatedAfterStarting != null && updatedAfterStarting.equals(lastIssueUpdatedDate)) {
            this.storeLastIssueUpdatedDate(null, this.projectKey, DateTimeUtils.roundDateTimeToMinutePrecise(new Date(lastIssueUpdatedDate.getTime() + 64000L)));
        }
    }

    protected void processDelete(Date boundDate) throws Exception {
        if (boundDate == null) {
            throw new IllegalArgumentException("boundDate must be set");
        }
        this.indexingInfo.issuesDeleted = 0;
        this.indexingInfo.commentsDeleted = 0;
        if (!this.indexingInfo.fullUpdate) {
            return;
        }
        this.logger.debug("Go to process JIRA deletes for project {} for issues not updated in index after {}", new Object[]{this.projectKey, boundDate});
        String indexName = this.jiraIssueIndexStructureBuilder.getIssuesSearchIndexName(this.projectKey);
        this.esIntegrationComponent.refreshSearchIndex(indexName);
        this.logger.debug("go to delete indexed issues for project {} not updated after {}", new Object[]{this.projectKey, boundDate});
        SearchRequestBuilder srb = this.esIntegrationComponent.prepareESScrollSearchRequestBuilder(indexName);
        this.jiraIssueIndexStructureBuilder.buildSearchForIndexedDocumentsNotUpdatedAfter(srb, this.projectKey, boundDate);
        SearchResponse scrollResp = this.esIntegrationComponent.executeESSearchRequest(srb);
        if (scrollResp.getHits().getTotalHits() > 0L) {
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            scrollResp = this.esIntegrationComponent.executeESScrollSearchNextRequest(scrollResp);
            BulkRequestBuilder esBulk = this.esIntegrationComponent.prepareESBulkRequestBuilder();
            while (scrollResp.getHits().getHits().length > 0) {
                for (SearchHit hit : scrollResp.getHits()) {
                    this.logger.debug("Go to delete indexed issue for document id {}", new Object[]{hit.getId()});
                    if (this.jiraIssueIndexStructureBuilder.deleteIssueDocument(esBulk, hit)) {
                        ++this.indexingInfo.issuesDeleted;
                        continue;
                    }
                    ++this.indexingInfo.commentsDeleted;
                }
                if (this.isClosed()) {
                    throw new InterruptedException("Interrupted because River is closed");
                }
                scrollResp = this.esIntegrationComponent.executeESScrollSearchNextRequest(scrollResp);
            }
            this.esIntegrationComponent.executeESBulkRequest(esBulk);
        }
    }

    protected boolean isClosed() {
        return this.esIntegrationComponent != null && this.esIntegrationComponent.isClosed();
    }

    protected Date readLastIssueUpdatedDate(String jiraProjectKey) throws Exception {
        return this.esIntegrationComponent.readDatetimeValue(jiraProjectKey, STORE_PROPERTYNAME_LAST_INDEXED_ISSUE_UPDATE_DATE);
    }

    protected void storeLastIssueUpdatedDate(BulkRequestBuilder esBulk, String jiraProjectKey, Date lastIssueUpdatedDate) throws Exception {
        this.esIntegrationComponent.storeDatetimeValue(jiraProjectKey, STORE_PROPERTYNAME_LAST_INDEXED_ISSUE_UPDATE_DATE, lastIssueUpdatedDate, esBulk);
    }

    public ProjectIndexingInfo getIndexingInfo() {
        return this.indexingInfo;
    }
}

