/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.jboss.elasticsearch.river.jira.DateTimeUtils;
import org.jboss.elasticsearch.river.jira.Utils;

public class ProjectIndexingInfo {
    private static final String DOCFIELD_ISSUES_DELETED = "issues_deleted";
    private static final String DOCVAL_RESULT_OK = "OK";
    private static final String DOCVAL_TYPE_FULL = "FULL";
    public static final String DOCFIELD_ERROR_MESSAGE = "error_message";
    public static final String DOCFIELD_TIME_ELAPSED = "time_elapsed";
    public static final String DOCFIELD_RESULT = "result";
    public static final String DOCFIELD_ISSUES_UPDATED = "issues_updated";
    public static final String DOCFIELD_UPDATE_TYPE = "update_type";
    public static final String DOCFIELD_START_DATE = "start_date";
    public static final String DOCFIELD_PROJECT_KEY = "project_key";
    public static final String DOCFIELD_RIVER_NAME = "river_name";
    public String projectKey;
    public boolean fullUpdate;
    public int issuesUpdated;
    public int issuesDeleted;
    public int commentsDeleted;
    public Date startDate;
    public boolean finishedOK;
    public long timeElapsed;
    public String errorMessage;

    public ProjectIndexingInfo(String projectKey, boolean fullUpdate) {
        this.projectKey = projectKey;
        this.fullUpdate = fullUpdate;
    }

    public ProjectIndexingInfo(String projectKey, boolean fullUpdate, int issuesUpdated, int issuesDeleted, int commentsDeleted, Date startDate, boolean finishedOK, long timeElapsed, String errorMessage) {
        this.projectKey = projectKey;
        this.fullUpdate = fullUpdate;
        this.issuesUpdated = issuesUpdated;
        this.issuesDeleted = issuesDeleted;
        this.commentsDeleted = commentsDeleted;
        this.startDate = startDate;
        this.finishedOK = finishedOK;
        this.timeElapsed = timeElapsed;
        this.errorMessage = errorMessage;
    }

    public XContentBuilder buildDocument(XContentBuilder builder, String riverName, boolean printProjectKey, boolean printFinalStatus) throws IOException {
        builder.startObject();
        if (riverName != null) {
            builder.field(DOCFIELD_RIVER_NAME, riverName);
        }
        if (printProjectKey) {
            builder.field(DOCFIELD_PROJECT_KEY, this.projectKey);
        }
        builder.field(DOCFIELD_UPDATE_TYPE, this.fullUpdate ? DOCVAL_TYPE_FULL : "INCREMENTAL");
        builder.field(DOCFIELD_START_DATE, this.startDate);
        builder.field(DOCFIELD_ISSUES_UPDATED, this.issuesUpdated);
        builder.field(DOCFIELD_ISSUES_DELETED, this.issuesDeleted);
        if (printFinalStatus) {
            builder.field(DOCFIELD_RESULT, this.finishedOK ? DOCVAL_RESULT_OK : "ERROR");
            builder.field(DOCFIELD_TIME_ELAPSED, this.timeElapsed + "ms");
            if (!this.finishedOK && !Utils.isEmpty(this.errorMessage)) {
                builder.field(DOCFIELD_ERROR_MESSAGE, this.errorMessage);
            }
        }
        builder.endObject();
        return builder;
    }

    public static ProjectIndexingInfo readFromDocument(Map<String, Object> document) {
        if (document == null) {
            return null;
        }
        ProjectIndexingInfo ret = new ProjectIndexingInfo((String)document.get(DOCFIELD_PROJECT_KEY), DOCVAL_TYPE_FULL.equals(document.get(DOCFIELD_UPDATE_TYPE)));
        ret.startDate = DateTimeUtils.parseISODateTime((String)document.get(DOCFIELD_START_DATE));
        ret.issuesUpdated = Utils.nodeIntegerValue(document.get(DOCFIELD_ISSUES_UPDATED));
        ret.issuesDeleted = Utils.nodeIntegerValue(document.get(DOCFIELD_ISSUES_DELETED));
        ret.finishedOK = DOCVAL_RESULT_OK.equals(document.get(DOCFIELD_RESULT));
        ret.timeElapsed = Long.parseLong(((String)document.get(DOCFIELD_TIME_ELAPSED)).replace("ms", ""));
        ret.errorMessage = (String)document.get(DOCFIELD_ERROR_MESSAGE);
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.projectKey == null ? 0 : this.projectKey.hashCode());
        return result;
    }
}

