/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm.fullupdate;

import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jboss.elasticsearch.river.jira.IJiraRiverMgm;
import org.jboss.elasticsearch.river.jira.mgm.TransportJRMgmBaseAction;
import org.jboss.elasticsearch.river.jira.mgm.fullupdate.FullUpdateRequest;
import org.jboss.elasticsearch.river.jira.mgm.fullupdate.FullUpdateResponse;
import org.jboss.elasticsearch.river.jira.mgm.fullupdate.NodeFullUpdateRequest;
import org.jboss.elasticsearch.river.jira.mgm.fullupdate.NodeFullUpdateResponse;

public class TransportFullUpdateAction
extends TransportJRMgmBaseAction<FullUpdateRequest, FullUpdateResponse, NodeFullUpdateRequest, NodeFullUpdateResponse> {
    @Inject
    public TransportFullUpdateAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, "jira_river/force_full_update", clusterName, threadPool, clusterService, transportService, actionFilters);
    }

    @Override
    protected NodeFullUpdateResponse performOperationOnJiraRiver(IJiraRiverMgm river, FullUpdateRequest req, DiscoveryNode node) throws Exception {
        this.logger.debug("Go to schedule full reindex for river '{}' and project {}", new Object[]{req.getRiverName(), req.getProjectKey()});
        String ret = river.forceFullReindex(req.getProjectKey());
        return new NodeFullUpdateResponse(node, true, ret != null, ret);
    }

    protected FullUpdateRequest newRequest() {
        return new FullUpdateRequest();
    }

    protected NodeFullUpdateRequest newNodeRequest() {
        return new NodeFullUpdateRequest();
    }

    protected NodeFullUpdateRequest newNodeRequest(String nodeId, FullUpdateRequest request) {
        return new NodeFullUpdateRequest(nodeId, request);
    }

    protected NodeFullUpdateResponse newNodeResponse() {
        return new NodeFullUpdateResponse(this.clusterService.localNode());
    }

    protected NodeFullUpdateResponse[] newNodeResponseArray(int len) {
        return new NodeFullUpdateResponse[len];
    }

    protected FullUpdateResponse newResponse(ClusterName clusterName, NodeFullUpdateResponse[] array) {
        return new FullUpdateResponse(clusterName, array);
    }
}

