/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.mgm;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestRequest;

public class RestXContentBuilder {
    public static XContentBuilder restContentBuilder(RestRequest request) throws IOException {
        String casing;
        XContentType contentType = XContentType.fromRestContentType((String)request.param("format", request.header("Content-Type")));
        if (contentType == null) {
            contentType = XContentType.JSON;
        }
        XContentBuilder builder = new XContentBuilder(XContentFactory.xContent((XContentType)contentType), (OutputStream)new BytesStreamOutput());
        if (request.paramAsBoolean("pretty", false)) {
            builder.prettyPrint().lfAtEnd();
        }
        if ((casing = request.param("case")) != null && "camelCase".equals(casing)) {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.CAMELCASE);
        } else {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.NONE);
        }
        return builder;
    }

    public static XContentBuilder emptyBuilder(RestRequest request) throws IOException {
        return RestXContentBuilder.restContentBuilder(request).startObject().endObject();
    }
}

