/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class Utils {
    public static String trimToNull(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        if ((src = src.trim()).length() == 0) {
            return null;
        }
        return src;
    }

    public static boolean isEmpty(String src) {
        return src == null || src.length() == 0 || src.trim().length() == 0;
    }

    public static boolean isEmpty(Object src) {
        return src == null || src instanceof String && Utils.isEmpty((String)src);
    }

    public static long parseTimeValue(Map<String, ? extends Object> settings, String key, long defaultDuration, TimeUnit defaultTimeUnit) {
        long ret = 0L;
        if (settings == null || !settings.containsKey(key)) {
            if (defaultTimeUnit != null) {
                ret = new TimeValue(defaultDuration, defaultTimeUnit).millis();
            }
        } else {
            try {
                ret = TimeValue.parseTimeValue((String)XContentMapValues.nodeStringValue((Object)settings.get(key), null), (TimeValue)new TimeValue(defaultDuration, defaultTimeUnit)).millis();
            }
            catch (ElasticsearchParseException e) {
                throw new ElasticsearchParseException(e.getMessage() + " for setting: " + key);
            }
        }
        return ret;
    }

    public static Integer nodeIntegerValue(Object node) throws NumberFormatException {
        if (node == null) {
            return null;
        }
        if (node instanceof Integer) {
            return (Integer)node;
        }
        if (node instanceof Number) {
            return new Integer(((Number)node).intValue());
        }
        return Integer.parseInt(node.toString());
    }

    public static Map<String, Object> loadJSONFromJarPackagedFile(String filePath) throws SettingsException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(Utils.class.getResourceAsStream(filePath));
            Map map = parser.mapAndClose();
            return map;
        }
    }
}

