/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.mgm.period;

import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jboss.elasticsearch.river.sysinfo.IRiverMgm;
import org.jboss.elasticsearch.river.sysinfo.mgm.TransportJRMgmBaseAction;
import org.jboss.elasticsearch.river.sysinfo.mgm.period.JRPeriodRequest;
import org.jboss.elasticsearch.river.sysinfo.mgm.period.JRPeriodResponse;
import org.jboss.elasticsearch.river.sysinfo.mgm.period.NodeJRPeriodRequest;
import org.jboss.elasticsearch.river.sysinfo.mgm.period.NodeJRPeriodResponse;

public class TransportJRPeriodAction
extends TransportJRMgmBaseAction<JRPeriodRequest, JRPeriodResponse, NodeJRPeriodRequest, NodeJRPeriodResponse> {
    @Inject
    public TransportJRPeriodAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, clusterName, threadPool, clusterService, transportService);
    }

    protected String transportAction() {
        return "sysinfo_river/period";
    }

    @Override
    protected NodeJRPeriodResponse performOperationOnRiver(IRiverMgm river, JRPeriodRequest req, DiscoveryNode node) throws Exception {
        this.logger.debug("Go to perform period change to {} for indexers {} on river '{}'", new Object[]{req.period, req.indexerNames, req.getRiverName()});
        boolean ret = river.changeIndexerPeriod(req.indexerNames, req.period);
        return new NodeJRPeriodResponse(node, true, ret);
    }

    protected JRPeriodRequest newRequest() {
        return new JRPeriodRequest();
    }

    protected NodeJRPeriodRequest newNodeRequest() {
        return new NodeJRPeriodRequest();
    }

    protected NodeJRPeriodRequest newNodeRequest(String nodeId, JRPeriodRequest request) {
        return new NodeJRPeriodRequest(nodeId, request);
    }

    protected NodeJRPeriodResponse newNodeResponse() {
        return new NodeJRPeriodResponse(this.clusterService.localNode());
    }

    protected NodeJRPeriodResponse[] newNodeResponseArray(int len) {
        return new NodeJRPeriodResponse[len];
    }

    protected JRPeriodResponse newResponse(ClusterName clusterName, NodeJRPeriodResponse[] array) {
        return new JRPeriodResponse(clusterName, array);
    }
}

