/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SettingsException;
import org.jboss.elasticsearch.river.sysinfo.SourceClientBase;
import org.jboss.elasticsearch.river.sysinfo.Utils;

public class SourceClientREST
extends SourceClientBase {
    protected static final String PARAM_NODE_ID = "nodeId";
    protected static final String PARAM_INDEX = "index";
    private static final ESLogger logger = Loggers.getLogger(SourceClientREST.class);
    protected CloseableHttpClient httpclient;
    protected String restAPIUrlBase;
    protected boolean isAuthConfigured = false;

    public SourceClientREST(Map<String, Object> sourceClientSettings) throws SettingsException {
        this.restAPIUrlBase = SourceClientREST.prepareAPIURLFromBaseURL((String)sourceClientSettings.get("urlBase"));
        if (this.restAPIUrlBase == null) {
            throw new SettingsException("Parameter es_connection/urlBase must be set!");
        }
        URL url = null;
        try {
            url = new URL(this.restAPIUrlBase);
        }
        catch (MalformedURLException e) {
            throw new SettingsException("Parameter es_connection/urlBase is malformed: " + e.getMessage());
        }
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultMaxPerRoute(20);
        connManager.setMaxTotal(20);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        int timeout = (int)Utils.parseTimeValue(sourceClientSettings, "timeout", 5L, TimeUnit.SECONDS);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        String username = Utils.trimToNull((String)sourceClientSettings.get("username"));
        String password = (String)sourceClientSettings.get("pwd");
        if (!Utils.isEmpty(username)) {
            if (password != null) {
                String host = url.getHost();
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(host, -1), (Credentials)new UsernamePasswordCredentials(username, password));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                this.isAuthConfigured = true;
            } else {
                logger.warn("Password not found so authentication is not used!", new Object[0]);
                username = null;
            }
        }
        this.httpclient = clientBuilder.build();
    }

    protected SourceClientREST() {
    }

    protected static String prepareAPIURLFromBaseURL(String baseURL) {
        if (Utils.isEmpty(baseURL)) {
            return null;
        }
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL;
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
    }

    @Override
    protected String readClusterStateInfo(Map<String, String> params) throws IOException, InterruptedException {
        return this.performRESTCall("_cluster/state", SourceClientREST.prepareRequestParams(params, null));
    }

    @Override
    protected String readClusterHealthInfo(Map<String, String> params) throws IOException, InterruptedException {
        String op = "_cluster/health";
        if (params != null && !Utils.isEmpty(params.get(PARAM_INDEX))) {
            op = op + "/" + params.get(PARAM_INDEX);
        }
        return this.performRESTCall(op, SourceClientREST.prepareRequestParams(params, PARAM_INDEX));
    }

    @Override
    protected String readClusterNodesInfoInfo(Map<String, String> params) throws IOException, InterruptedException {
        String op = "_cluster/nodes";
        if (params != null && !Utils.isEmpty(params.get(PARAM_NODE_ID))) {
            op = op + "/" + params.get(PARAM_NODE_ID);
        }
        return this.performRESTCall(op, SourceClientREST.prepareRequestParams(params, PARAM_NODE_ID));
    }

    @Override
    protected String readClusterNodesStatsInfo(Map<String, String> params) throws IOException, InterruptedException {
        String op = "_nodes";
        if (params != null && !Utils.isEmpty(params.get(PARAM_NODE_ID))) {
            op = op + "/" + params.get(PARAM_NODE_ID);
        }
        op = op + "/stats";
        return this.performRESTCall(op, SourceClientREST.prepareRequestParams(params, PARAM_NODE_ID));
    }

    @Override
    protected String readIndicesStatusInfo(Map<String, String> params) throws IOException, InterruptedException {
        String op = "";
        if (params != null && !Utils.isEmpty(params.get(PARAM_INDEX))) {
            op = params.get(PARAM_INDEX) + "/";
        }
        op = op + "_status";
        return this.performRESTCall(op, SourceClientREST.prepareRequestParams(params, PARAM_INDEX));
    }

    @Override
    protected String readIndicesStatsInfo(Map<String, String> params) throws IOException, InterruptedException {
        String op = "";
        if (params != null && !Utils.isEmpty(params.get(PARAM_INDEX))) {
            op = params.get(PARAM_INDEX) + "/";
        }
        op = op + "_stats";
        return this.performRESTCall(op, SourceClientREST.prepareRequestParams(params, PARAM_INDEX));
    }

    @Override
    protected String readIndicesSegmentsInfo(Map<String, String> params) throws IOException, InterruptedException {
        String op = "";
        if (params != null && !Utils.isEmpty(params.get(PARAM_INDEX))) {
            op = params.get(PARAM_INDEX) + "/";
        }
        op = op + "_segments";
        return this.performRESTCall(op, SourceClientREST.prepareRequestParams(params, PARAM_INDEX));
    }

    protected static NameValuePair[] prepareRequestParams(Map<String, String> params, String removeParamName) {
        if (params == null || params.isEmpty() || params.size() == 1 && removeParamName != null && params.containsKey(removeParamName)) {
            return null;
        }
        ArrayList<BasicNameValuePair> paramsOut = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (String paramName : params.keySet()) {
                if (removeParamName != null && removeParamName.equals(paramName)) continue;
                paramsOut.add(new BasicNameValuePair(paramName, params.get(paramName)));
            }
        }
        return paramsOut.toArray(new NameValuePair[paramsOut.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String performRESTCall(String restOperation, NameValuePair[] requestParams) throws IOException {
        String string;
        HttpGet method;
        block11: {
            String url = this.restAPIUrlBase + restOperation;
            logger.debug("Go to perform ES REST API call to the {} with parameters {}", new Object[]{url, requestParams});
            URIBuilder builder = new URIBuilder(url);
            if (requestParams != null) {
                for (NameValuePair param : requestParams) {
                    builder.addParameter(param.getName(), param.getValue());
                }
            }
            method = new HttpGet(builder.build());
            method.addHeader("Accept", "application/json");
            CloseableHttpResponse response = null;
            try {
                HttpHost targetHost = new HttpHost(builder.getHost(), builder.getPort(), builder.getScheme());
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(targetHost, (AuthScheme)basicAuth);
                HttpClientContext localcontext = HttpClientContext.create();
                localcontext.setAuthCache((AuthCache)authCache);
                response = this.httpclient.execute(targetHost, (HttpRequest)method, (HttpContext)localcontext);
                int statusCode = response.getStatusLine().getStatusCode();
                String responseContent = null;
                if (response.getEntity() != null) {
                    responseContent = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                }
                if (statusCode != 200) {
                    throw new IOException("Failed ES REST API call. HTTP error code: " + statusCode + " Response body: " + responseContent);
                }
                string = responseContent;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        response.close();
                    }
                    method.releaseConnection();
                    throw throwable;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException("Failed ES REST API call: " + e.getMessage(), e);
                }
            }
            response.close();
        }
        method.releaseConnection();
        return string;
    }
}

