/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.mgm.lifecycle;

import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jboss.elasticsearch.river.sysinfo.IRiverMgm;
import org.jboss.elasticsearch.river.sysinfo.mgm.TransportJRMgmBaseAction;
import org.jboss.elasticsearch.river.sysinfo.mgm.lifecycle.JRLifecycleCommand;
import org.jboss.elasticsearch.river.sysinfo.mgm.lifecycle.JRLifecycleRequest;
import org.jboss.elasticsearch.river.sysinfo.mgm.lifecycle.JRLifecycleResponse;
import org.jboss.elasticsearch.river.sysinfo.mgm.lifecycle.NodeJRLifecycleRequest;
import org.jboss.elasticsearch.river.sysinfo.mgm.lifecycle.NodeJRLifecycleResponse;

public class TransportJRLifecycleAction
extends TransportJRMgmBaseAction<JRLifecycleRequest, JRLifecycleResponse, NodeJRLifecycleRequest, NodeJRLifecycleResponse> {
    @Inject
    public TransportJRLifecycleAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, "sysinfo_river/lifecycle", clusterName, threadPool, clusterService, transportService);
    }

    @Override
    protected NodeJRLifecycleResponse performOperationOnRiver(IRiverMgm river, JRLifecycleRequest req, DiscoveryNode node) throws Exception {
        JRLifecycleCommand command = req.getCommand();
        this.logger.debug("Go to perform lifecycle command {} on river '{}'", new Object[]{command, req.getRiverName()});
        switch (command) {
            case STOP: {
                river.stop();
                break;
            }
            case RESTART: {
                river.restart();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Command " + (Object)((Object)command) + " is not supported");
            }
        }
        return new NodeJRLifecycleResponse(node, true);
    }

    protected JRLifecycleRequest newRequest() {
        return new JRLifecycleRequest();
    }

    protected NodeJRLifecycleRequest newNodeRequest() {
        return new NodeJRLifecycleRequest();
    }

    protected NodeJRLifecycleRequest newNodeRequest(String nodeId, JRLifecycleRequest request) {
        return new NodeJRLifecycleRequest(nodeId, request);
    }

    protected NodeJRLifecycleResponse newNodeResponse() {
        return new NodeJRLifecycleResponse(this.clusterService.localNode());
    }

    protected NodeJRLifecycleResponse[] newNodeResponseArray(int len) {
        return new NodeJRLifecycleResponse[len];
    }

    protected JRLifecycleResponse newResponse(ClusterName clusterName, NodeJRLifecycleResponse[] array) {
        return new JRLifecycleResponse(clusterName, array);
    }
}

