/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.esclient;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.admin.cluster.health.RestClusterHealthAction;
import org.elasticsearch.rest.action.admin.cluster.node.info.RestNodesInfoAction;
import org.elasticsearch.rest.action.admin.cluster.node.stats.RestNodesStatsAction;
import org.elasticsearch.rest.action.admin.cluster.state.RestClusterStateAction;
import org.elasticsearch.rest.action.admin.indices.segments.RestIndicesSegmentsAction;
import org.elasticsearch.rest.action.admin.indices.stats.RestIndicesStatsAction;
import org.elasticsearch.rest.action.admin.indices.status.RestIndicesStatusAction;
import org.jboss.elasticsearch.river.sysinfo.SourceClientBase;
import org.jboss.elasticsearch.river.sysinfo.esclient.LocalRestChannel;
import org.jboss.elasticsearch.river.sysinfo.esclient.LocalRestRequest;

public class SourceClientESClient
extends SourceClientBase {
    private static final ESLogger logger = Loggers.getLogger(SourceClientESClient.class);
    protected Client client;
    private RestClusterHealthAction healthAction;
    private RestClusterStateAction stateAction;
    private RestNodesInfoAction nodesInfoAction;
    private RestNodesStatsAction nodesStatsAction;
    private RestIndicesStatusAction indicesStatusAction;
    private RestIndicesStatsAction indicesStatsAction;
    private RestIndicesSegmentsAction indicesSegmentsAction;

    public SourceClientESClient(Client client) {
        this.client = client;
        Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        SettingsFilter settingsFilter = new SettingsFilter(settings);
        RestController controller = new RestController(settings);
        this.healthAction = new RestClusterHealthAction(settings, controller, client);
        this.stateAction = new RestClusterStateAction(settings, controller, client, settingsFilter);
        this.nodesInfoAction = new RestNodesInfoAction(settings, controller, client, settingsFilter);
        this.nodesStatsAction = new RestNodesStatsAction(settings, controller, client);
        this.indicesStatusAction = new RestIndicesStatusAction(settings, controller, client, settingsFilter);
        this.indicesStatsAction = new RestIndicesStatsAction(settings, controller, client);
        this.indicesSegmentsAction = new RestIndicesSegmentsAction(settings, controller, client);
    }

    @Override
    protected String readClusterStateInfo(Map<String, String> params) throws IOException, InterruptedException {
        logger.debug("readClusterStateInfo with params {}", new Object[]{params});
        return this.performRestRequestLocally((RestHandler)this.stateAction, params);
    }

    @Override
    protected String readClusterHealthInfo(Map<String, String> params) throws IOException, InterruptedException {
        logger.debug("readClusterHealthInfo with params {}", new Object[]{params});
        return this.performRestRequestLocally((RestHandler)this.healthAction, params);
    }

    @Override
    protected String readClusterNodesInfoInfo(Map<String, String> params) throws IOException, InterruptedException {
        logger.debug("readClusterNodesInfoInfo with params {}", new Object[]{params});
        return this.performRestRequestLocally((RestHandler)this.nodesInfoAction, params);
    }

    @Override
    protected String readClusterNodesStatsInfo(Map<String, String> params) throws IOException, InterruptedException {
        logger.debug("readClusterNodesStatsInfo with params {}", new Object[]{params});
        return this.performRestRequestLocally((RestHandler)this.nodesStatsAction, params);
    }

    @Override
    protected String readIndicesStatusInfo(Map<String, String> params) throws IOException, InterruptedException {
        logger.debug("readIndicesStatusInfo with params {}", new Object[]{params});
        return this.performRestRequestLocally((RestHandler)this.indicesStatusAction, params);
    }

    @Override
    protected String readIndicesStatsInfo(Map<String, String> params) throws IOException, InterruptedException {
        logger.debug("readIndicesStatsInfo with params {}", new Object[]{params});
        return this.performRestRequestLocally((RestHandler)this.indicesStatsAction, params);
    }

    @Override
    protected String readIndicesSegmentsInfo(Map<String, String> params) throws IOException, InterruptedException {
        logger.debug("readIndicesSegmentsInfo with params {}", new Object[]{params});
        return this.performRestRequestLocally((RestHandler)this.indicesSegmentsAction, params);
    }

    private String performRestRequestLocally(RestHandler handler, Map<String, String> params) throws IOException, InterruptedException {
        LocalRestRequest request = new LocalRestRequest(params);
        LocalRestChannel channel = new LocalRestChannel(request);
        try {
            handler.handleRequest((RestRequest)request, (RestChannel)channel);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e.getCause());
        }
        String res = channel.getResponseContent();
        logger.debug("performRestRequestLocally response {}", new Object[]{res});
        return res;
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
    }
}

