/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.mgm.riverslist;

import java.io.IOException;
import java.util.HashSet;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.jboss.elasticsearch.river.sysinfo.mgm.RestJRMgmBaseAction;
import org.jboss.elasticsearch.river.sysinfo.mgm.RestXContentBuilder;
import org.jboss.elasticsearch.river.sysinfo.mgm.riverslist.ListRiversAction;
import org.jboss.elasticsearch.river.sysinfo.mgm.riverslist.ListRiversRequest;
import org.jboss.elasticsearch.river.sysinfo.mgm.riverslist.ListRiversResponse;
import org.jboss.elasticsearch.river.sysinfo.mgm.riverslist.NodeListRiversResponse;

public class RestListRiversAction
extends RestJRMgmBaseAction {
    @Inject
    protected RestListRiversAction(Settings settings, Client client, RestController controller) {
        super(settings, client, controller);
        controller.registerHandler(RestRequest.Method.GET, "/_sysinfo_river/list", (RestHandler)this);
    }

    public void handleRequest(final RestRequest restRequest, final RestChannel restChannel, Client client) {
        ListRiversRequest actionRequest = new ListRiversRequest();
        this.logger.debug("Go to look for Sysinfo rivers in cluster", new Object[0]);
        client.admin().cluster().execute((Action)ListRiversAction.INSTANCE, (ActionRequest)actionRequest, (ActionListener)new ActionListener<ListRiversResponse>(){

            public void onResponse(ListRiversResponse response) {
                try {
                    HashSet<String> allRivers = new HashSet<String>();
                    for (NodeListRiversResponse node : (NodeListRiversResponse[])response.getNodes()) {
                        if (node.riverNames == null) continue;
                        allRivers.addAll(node.riverNames);
                    }
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(restRequest);
                    builder.startObject();
                    builder.field("sysinfo_river_names", allRivers);
                    builder.endObject();
                    restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Throwable e) {
                try {
                    restChannel.sendResponse((RestResponse)new BytesRestResponse(restChannel, e));
                }
                catch (IOException e1) {
                    RestListRiversAction.this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
                }
            }
        });
    }
}

