/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.type.TimestampType;
import org.hibernate.type.VersionType;

public class DbTimestampType
extends TimestampType
implements VersionType {
    private static final Log log = LogFactory.getLog(DbTimestampType.class);

    public String getName() {
        return "dbtimestamp";
    }

    public Object seed(SessionImplementor session) {
        if (session == null) {
            log.trace((Object)"incoming session was null; using current jvm time");
            return super.seed(session);
        }
        if (!session.getFactory().getDialect().supportsCurrentTimestampSelection()) {
            log.debug((Object)"falling back to vm-based timestamp, as dialect does not support current timestamp selection");
            return super.seed(session);
        }
        return this.getCurrentTimestamp(session);
    }

    private Timestamp getCurrentTimestamp(SessionImplementor session) {
        Dialect dialect = session.getFactory().getDialect();
        String timestampSelectString = dialect.getCurrentTimestampSelectString();
        if (dialect.isCurrentTimestampSelectStringCallable()) {
            return this.useCallableStatement(timestampSelectString, session);
        }
        return this.usePreparedStatement(timestampSelectString, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Timestamp usePreparedStatement(String timestampSelectString, SessionImplementor session) {
        Timestamp timestamp;
        PreparedStatement ps = null;
        try {
            try {
                ps = session.getBatcher().prepareStatement(timestampSelectString);
                ResultSet rs = session.getBatcher().getResultSet(ps);
                rs.next();
                Timestamp ts = rs.getTimestamp(1);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("current timestamp retreived from db : " + ts + " (nanos=" + ts.getNanos() + ", time=" + ts.getTime() + ")"));
                }
                timestamp = ts;
                Object var8_8 = null;
                if (ps == null) return timestamp;
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not select current db timestamp", timestampSelectString);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (ps == null) throw throwable;
            try {
                session.getBatcher().closeStatement(ps);
                throw throwable;
            }
            catch (SQLException sqle2) {
                log.warn((Object)"unable to clean up prepared statement", (Throwable)sqle2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException sqle2) {
            log.warn((Object)"unable to clean up prepared statement", (Throwable)sqle2);
            return timestamp;
        }
        session.getBatcher().closeStatement(ps);
        return timestamp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Timestamp useCallableStatement(String callString, SessionImplementor session) {
        Timestamp timestamp;
        CallableStatement cs = null;
        try {
            try {
                cs = session.getBatcher().prepareCallableStatement(callString);
                cs.registerOutParameter(1, 93);
                cs.execute();
                Timestamp ts = cs.getTimestamp(1);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("current timestamp retreived from db : " + ts + " (nanos=" + ts.getNanos() + ", time=" + ts.getTime() + ")"));
                }
                timestamp = ts;
                Object var7_7 = null;
                if (cs == null) return timestamp;
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not call current db timestamp function", callString);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (cs == null) throw throwable;
            try {
                session.getBatcher().closeStatement(cs);
                throw throwable;
            }
            catch (SQLException sqle2) {
                log.warn((Object)"unable to clean up callable statement", (Throwable)sqle2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException sqle2) {
            log.warn((Object)"unable to clean up callable statement", (Throwable)sqle2);
            return timestamp;
        }
        session.getBatcher().closeStatement(cs);
        return timestamp;
    }
}

