/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.api.server;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getTccl() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static String getSystemProperty(final String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key was null");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    static void setSystemProperty(final String key, final String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key was null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value was null");
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty(key, value);
                return null;
            }
        });
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

