/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.jnp.interfaces.NamingContextFactory;

public abstract class DelegatingContextFactory
implements InitialContextFactory {
    public static final String INITIAL_CONTEXT_FACTORY_DELEGATE = "jboss.embedded.initial.context.factory.delegate";
    public static final String INITIAL_CONTEXT_FACTORY_DEFAULT = "org.jnp.interfaces.NamingContextFactory";
    private NamingContextFactory delegate;

    protected synchronized NamingContextFactory getDelegate(Hashtable env) throws NamingException {
        if (this.delegate != null) {
            return this.delegate;
        }
        String factoryName = (String)env.get(INITIAL_CONTEXT_FACTORY_DELEGATE);
        if (factoryName != null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryName);
                this.delegate = (NamingContextFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to initialize InitialContextFactory", e);
            }
        } else {
            this.delegate = new NamingContextFactory();
        }
        return this.delegate;
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        return this.getDelegate(env).getInitialContext(env);
    }
}

