/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.domain;

import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.domain.ScopedClassLoaderDomain;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;

public class ScopedRepositoryClassLoaderDomain
extends ScopedClassLoaderDomain {
    public ScopedRepositoryClassLoaderDomain(ClassLoader loader, String name, boolean parentDelegation, AspectManager manager, boolean parentFirst) {
        super(loader, name, parentDelegation, manager, parentFirst);
    }

    public boolean isValid() {
        RepositoryClassLoader cl = (RepositoryClassLoader)this.getClassLoader();
        if (cl == null) {
            return false;
        }
        return cl.getLoaderRepository() != null;
    }

    protected Object getPerVmAspectWithNoParentDelegation(String def) {
        Object aspect = this.myPerVMAspects.get(def);
        if (aspect != null) {
            return aspect;
        }
        aspect = super.getSuperPerVmAspect(def);
        if (aspect != null) {
            HeirarchicalLoaderRepository3 myRepository;
            LoaderRepository loadingRepository = this.getAspectRepository(aspect);
            if (loadingRepository == (myRepository = this.getScopedRepository())) {
                this.myPerVMAspects.put(def, aspect);
            } else {
                try {
                    Class clazz = ((LoaderRepository)myRepository).loadClass(aspect.getClass().getName());
                    if (clazz == aspect.getClass()) {
                        this.notMyPerVMAspects.put(def, Boolean.TRUE);
                    } else {
                        AspectDefinition aspectDefinition = this.getAspectDefinition(def);
                        aspect = this.createPerVmAspect(def, aspectDefinition, this.getClassLoader());
                        this.myPerVMAspects.put(def, aspect);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return aspect;
    }

    private LoaderRepository getAspectRepository(Object aspect) {
        ClassLoader cl;
        for (ClassLoader parent = cl = aspect.getClass().getClassLoader(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof RepositoryClassLoader)) continue;
            return ((RepositoryClassLoader)parent).getLoaderRepository();
        }
        return null;
    }

    private HeirarchicalLoaderRepository3 getScopedRepository() {
        ClassLoader classloader = this.getClassLoader();
        if (classloader == null) {
            throw new IllegalStateException("ClassLoader no longer exists: " + this.classLoaderString);
        }
        if (!(classloader instanceof RepositoryClassLoader)) {
            throw new IllegalStateException("ClassLoader is not an instanceof RepositoryClassLoader " + this.classLoaderString);
        }
        RepositoryClassLoader repositoryClassLoader = (RepositoryClassLoader)classloader;
        LoaderRepository loaderRepository = repositoryClassLoader.getLoaderRepository();
        if (loaderRepository == null) {
            throw new IllegalStateException("ClassLoader has been undeployed: " + this.classLoaderString);
        }
        if (!(loaderRepository instanceof HeirarchicalLoaderRepository3)) {
            throw new IllegalStateException("Repository " + loaderRepository + " for classlaoder " + this.classLoaderString + " is not an HeirarchicalLoaderRepository3");
        }
        return (HeirarchicalLoaderRepository3)loaderRepository;
    }
}

