/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.lifecycle;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aop.Advisor;
import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackDefinition;
import org.jboss.aop.pointcut.TypeMatcher;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleCallbackBinding {
    protected String name;
    protected ClassExpression classes;
    protected ASTStart ast;
    List<LifecycleCallbackDefinition> lifecycleCallbackDefinitions = new ArrayList<LifecycleCallbackDefinition>();
    Object controllerState;

    public LifecycleCallbackBinding(String name, String classString, String typeExpression, Object controllerState) throws Exception {
        this.name = name;
        if (classString == null && typeExpression == null) {
            throw new RuntimeException("Need either classString or typeExpression");
        }
        if (classString != null && typeExpression != null) {
            throw new RuntimeException("Should not use both classString and typeExpression");
        }
        if (classString != null) {
            this.classes = new ClassExpression(classString);
        } else if (typeExpression != null) {
            this.ast = new TypeExpressionParser(new StringReader(typeExpression)).Start();
        }
        this.controllerState = controllerState;
    }

    public String getName() {
        return this.name;
    }

    public void addLifecycleCallback(String bean, String installMethod, String uninstallMethod) {
        this.lifecycleCallbackDefinitions.add(new LifecycleCallbackDefinition(bean, installMethod, uninstallMethod));
    }

    public List<LifecycleCallbackDefinition> getLifecycleCallbacks() {
        return this.lifecycleCallbackDefinitions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LifecycleCallbackBinding)) {
            return false;
        }
        return ((LifecycleCallbackBinding)obj).getName().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean matches(Advisor advisor, Class clazz) {
        if (this.classes != null) {
            return Util.matchesClassExpr(this.classes, clazz, advisor);
        }
        TypeMatcher matcher = new TypeMatcher(advisor, clazz);
        return (Boolean)this.ast.jjtAccept(matcher, null);
    }

    public Object getControllerState() {
        return this.controllerState;
    }
}

