/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    SecurityActions() {
    }

    static Method[] getDeclaredMethods(Class clazz) {
        if (System.getSecurityManager() == null) {
            return GetDeclaredMethodsAction.NON_PRIVILEGED.getDeclaredMethods(clazz);
        }
        return GetDeclaredMethodsAction.PRIVILEGED.getDeclaredMethods(clazz);
    }

    static Constructor[] getDeclaredConstructors(Class clazz) {
        if (System.getSecurityManager() == null) {
            return GetDeclaredConstructorsAction.NON_PRIVILEGED.getDeclaredConstructors(clazz);
        }
        return GetDeclaredConstructorsAction.PRIVILEGED.getDeclaredConstructors(clazz);
    }

    static interface GetDeclaredConstructorsAction {
        public static final GetDeclaredConstructorsAction PRIVILEGED = new GetDeclaredConstructorsAction(){

            public Constructor[] getDeclaredConstructors(final Class clazz) {
                try {
                    return (Constructor[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return clazz.getDeclaredConstructors();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        public static final GetDeclaredConstructorsAction NON_PRIVILEGED = new GetDeclaredConstructorsAction(){

            public Constructor[] getDeclaredConstructors(Class clazz) {
                return clazz.getDeclaredConstructors();
            }
        };

        public Constructor[] getDeclaredConstructors(Class var1);
    }

    static interface GetDeclaredMethodsAction {
        public static final GetDeclaredMethodsAction PRIVILEGED = new GetDeclaredMethodsAction(){

            public Method[] getDeclaredMethods(final Class clazz) {
                try {
                    return (Method[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return clazz.getDeclaredMethods();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        public static final GetDeclaredMethodsAction NON_PRIVILEGED = new GetDeclaredMethodsAction(){

            public Method[] getDeclaredMethods(Class clazz) {
                return clazz.getDeclaredMethods();
            }
        };

        public Method[] getDeclaredMethods(Class var1);
    }
}

