/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.explicit;

import java.io.IOException;
import java.net.URL;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.plugins.structure.explicit.StructureMetaDataObjectFactory;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class DeclaredStructure
extends AbstractStructureDeployer {
    public DeclaredStructure() {
        this.setRelativeOrder(0);
    }

    public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException {
        block6: {
            try {
                boolean isJBossStructure;
                boolean trace;
                block7: {
                    trace = this.log.isTraceEnabled();
                    if (this.isLeaf(file)) break block6;
                    isJBossStructure = false;
                    if (trace) {
                        this.log.trace(file + " is not a leaf");
                    }
                    try {
                        VirtualFile jbossStructure = file.findChild("META-INF/jboss-structure.xml");
                        this.log.trace("... context has a META-INF/jboss-structure.xml");
                        URL url = jbossStructure.toURL();
                        UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
                        Unmarshaller unmarshaller = factory.newUnmarshaller();
                        StructureMetaDataObjectFactory ofactory = new StructureMetaDataObjectFactory();
                        unmarshaller.unmarshal(url.toString(), (ObjectModelFactory)ofactory, (Object)metaData);
                        isJBossStructure = true;
                    }
                    catch (IOException e) {
                        if (!trace) break block7;
                        this.log.trace("... no META-INF/jboss-structure.xml.");
                    }
                }
                if (trace) {
                    this.log.trace(file + " isJBossStructure: " + isJBossStructure);
                }
                return isJBossStructure;
            }
            catch (Exception e) {
                throw DeploymentException.rethrowAsDeploymentException("Error determining structure: " + file.getName(), e);
            }
        }
        return false;
    }
}

