/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.keygen.GetTCLAction;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.logging.Logger;

public class JDBCMySQLCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private static final Logger log = Logger.getLogger(JDBCMySQLCreateCommand.class);
    private String className;
    private String methodName;
    private Method method;
    private Method getUnderlyingStatement;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        super.init(manager);
        ClassLoader loader = GetTCLAction.getContextClassLoader();
        try {
            Class<?> psClass = loader.loadClass(this.className);
            this.method = psClass.getMethod(this.methodName, null);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load driver class: " + this.className, e);
        }
        catch (NoSuchMethodException e) {
            throw new DeploymentException("Driver does not have method: " + this.methodName + "()");
        }
        try {
            Class<?> wrapperClass = loader.loadClass("org.jboss.resource.adapter.jdbc.StatementAccess");
            this.getUnderlyingStatement = wrapperClass.getMethod("getUnderlyingStatement", null);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load org.jboss.resource.adapter.jdbc.StatementAccess", e);
        }
        catch (NoSuchMethodException e) {
            throw new DeploymentException("StatementAccess.getUnderlyingStatement not found", e);
        }
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        super.initEntityCommand(entityCommand);
        this.className = entityCommand.getAttribute("class-name");
        if (this.className == null) {
            this.className = "com.mysql.jdbc.PreparedStatement";
        }
        this.methodName = entityCommand.getAttribute("method");
        if (this.methodName == null) {
            this.methodName = "getGeneratedKeys";
        }
    }

    protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException {
        int rows = ps.executeUpdate();
        Statement stmt = ps;
        do {
            try {
                Object[] args = new Object[]{};
                stmt = (Statement)this.getUnderlyingStatement.invoke((Object)stmt, args);
            }
            catch (IllegalAccessException e) {
                SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
                ex.initCause(e);
                throw ex;
            }
            catch (InvocationTargetException e) {
                SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
                ex.initCause(e);
                throw ex;
            }
        } while (stmt != null && !this.method.getDeclaringClass().isInstance(stmt));
        ResultSet rs = null;
        try {
            try {
                rs = (ResultSet)this.method.invoke((Object)stmt, null);
                if (!rs.next()) {
                    throw new EJBException("getGeneratedKeys returned an empty ResultSet");
                }
                this.pkField.loadInstanceResults(rs, 1, ctx);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException("Error extracting generated keys", e);
            }
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            JDBCUtil.safeClose(rs);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        return rows;
    }
}

