/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.aop.annotation.AnnotationRepository;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.EJBMetaDataLoader;
import org.jboss.logging.Logger;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.loader.reflection.ClassMetaDataRetrievalFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;

public class AnnotationRepositoryToMetaData
extends AnnotationRepository {
    private static final Logger log = Logger.getLogger(AnnotationRepositoryToMetaData.class);
    private MetaData metaData;
    private MemoryMetaDataLoader mutableMetaData;
    private ClassLoader classLoader;

    public AnnotationRepositoryToMetaData(EJBContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("Null container");
        }
        Class beanClass = container.getClazz();
        if (beanClass == null) {
            throw new IllegalArgumentException("Null bean class");
        }
        String name = container.getObjectName().getCanonicalName();
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.classLoader = container.getClassloader();
        if (this.classLoader == null) {
            throw new IllegalArgumentException("Null class");
        }
        MetaDataRetrieval classMetaData = ClassMetaDataRetrievalFactory.INSTANCE.getMetaDataRetrieval(new Scope(CommonLevels.CLASS, beanClass));
        ScopeKey instanceScope = new ScopeKey(CommonLevels.INSTANCE, name);
        this.mutableMetaData = new MemoryMetaDataLoader(instanceScope);
        EJBMetaDataLoader dynamicXml = new EJBMetaDataLoader(instanceScope, container);
        AbstractMetaDataContext classContext = new AbstractMetaDataContext(classMetaData);
        MetaDataRetrieval[] instance = new MetaDataRetrieval[]{dynamicXml, this.mutableMetaData};
        AbstractMetaDataContext instanceContext = new AbstractMetaDataContext((MetaDataContext)classContext, Arrays.asList(instance));
        this.metaData = new MetaDataRetrievalToMetaDataBridge(instanceContext);
    }

    protected static Signature getSignature(CtMember member) {
        if (member == null) {
            throw new IllegalArgumentException("Null member");
        }
        try {
            if (member instanceof CtMethod) {
                CtMethod method = (CtMethod)member;
                CtClass[] parameterTypes = method.getParameterTypes();
                String[] params = Signature.NO_PARAMETERS;
                if (parameterTypes.length > 0) {
                    params = new String[parameterTypes.length];
                    for (int i = 0; i < params.length; ++i) {
                        params[i] = parameterTypes[i].getName();
                    }
                }
                return new MethodSignature(method.getName(), params);
            }
            if (member instanceof CtConstructor) {
                CtConstructor constructor = (CtConstructor)member;
                CtClass[] parameterTypes = constructor.getParameterTypes();
                String[] params = Signature.NO_PARAMETERS;
                if (parameterTypes.length > 0) {
                    params = new String[parameterTypes.length];
                    for (int i = 0; i < params.length; ++i) {
                        params[i] = parameterTypes[i].getName();
                    }
                }
                return new ConstructorSignature(params);
            }
            if (member instanceof CtField) {
                return new FieldSignature(member.getName());
            }
            throw new IllegalArgumentException("Unknown member type: " + member);
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Error determing signature: " + member, e);
        }
    }

    protected Annotation initAnnotation(Object annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        if (annotation instanceof Annotation) {
            return (Annotation)annotation;
        }
        if (!(annotation instanceof String)) {
            throw new IllegalArgumentException("Not an annotation: " + annotation);
        }
        try {
            return (Annotation)AnnotationCreator.createAnnotation((String)annotation, this.classLoader);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating annotation: " + annotation, e);
        }
    }

    protected Class loadClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class for annotation " + className + " using class loader " + this.classLoader);
        }
    }

    public void addAnnotation(CtMember m, String annotation) {
        this.mutableMetaData.addAnnotation(AnnotationRepositoryToMetaData.getSignature(m), this.initAnnotation(annotation));
    }

    public void addAnnotation(Member m, Class annotation, Object value) {
        this.mutableMetaData.addAnnotation(m, this.initAnnotation(value));
    }

    public void addAnnotation(Member m, String annotation, Object value) {
        this.mutableMetaData.addAnnotation(m, this.initAnnotation(value));
    }

    public void addClassAnnotation(Class annotation, Object value) {
        this.mutableMetaData.addAnnotation(this.initAnnotation(value));
    }

    public void addClassAnnotation(String annotation, String value) {
        this.mutableMetaData.addAnnotation(this.initAnnotation(value));
    }

    public void disableAnnotation(Member m, String annotation) {
        log.warn("Not implemented: disableAnnotation(" + m + ", " + annotation + ")");
    }

    public void disableAnnotation(String annotation) {
        log.warn("Not implemented: disableAnnotation(" + annotation + ")");
    }

    public void enableAnnotation(String annotation) {
        log.warn("Not implemented: enableAnnotation(" + annotation + ")");
    }

    public Map getAnnotations() {
        log.warn("Not implemented: getAnnotations()");
        return Collections.emptyMap();
    }

    public Map getClassAnnotations() {
        log.warn("Not implemented: getClassAnnotations()");
        return Collections.emptyMap();
    }

    public boolean hasAnnotation(CtMember m, String annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        MetaData component = this.metaData.getComponentMetaData(AnnotationRepositoryToMetaData.getSignature(m));
        if (component == null) {
            return false;
        }
        return component.isMetaDataPresent(annotation);
    }

    public boolean hasAnnotation(Member m, Class annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        MetaData component = this.metaData.getComponentMetaData(Signature.getSignature(m));
        if (component == null) {
            return false;
        }
        return component.isAnnotationPresent(annotation);
    }

    public boolean hasAnnotation(Member m, String annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        MetaData component = this.metaData.getComponentMetaData(Signature.getSignature(m));
        if (component == null) {
            return false;
        }
        return component.isAnnotationPresent(this.loadClass(annotation));
    }

    public boolean hasClassAnnotation(Class annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        return this.metaData.isAnnotationPresent(annotation);
    }

    public boolean hasClassAnnotation(String annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        return this.metaData.isAnnotationPresent(this.loadClass(annotation));
    }

    public boolean isDisabled(Class annotation) {
        return false;
    }

    public boolean isDisabled(Member m, Class annotation) {
        return false;
    }

    public boolean isDisabled(Member m, String annotation) {
        return false;
    }

    public boolean isDisabled(String annotation) {
        return false;
    }

    public Object resolveClassAnnotation(Class annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        return this.metaData.getAnnotation(annotation);
    }

    public Object resolveAnnotation(Member m, Class annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        MetaData component = this.metaData.getComponentMetaData(Signature.getSignature(m));
        if (component == null) {
            return null;
        }
        return component.getAnnotation(annotation);
    }

    protected Object resolveAnnotation(Member m, String annotation) {
        return this.resolveAnnotation(m, this.loadClass(annotation));
    }
}

