/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Properties;
import javax.management.ObjectName;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.ejb3.entity.JBCCache;
import org.jboss.ejb3.entity.OptimisticJBCCache;
import org.jboss.ejb3.entity.TransactionalCacheFactory;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;

class JBCCacheFactory
extends TransactionalCacheFactory {
    private org.jboss.cache.Cache cache;
    private boolean optimistic;

    JBCCacheFactory() {
    }

    protected void configure(Properties hibernateConfig) {
        try {
            String cacheName = (String)hibernateConfig.get("hibernate.treecache.mbean.object_name");
            if (cacheName == null) {
                cacheName = "jboss.cache:service=EJB3EntityTreeCache";
            }
            ObjectName mbeanObjectName = new ObjectName(cacheName);
            CacheJmxWrapperMBean mbean = (CacheJmxWrapperMBean)MBeanProxyExt.create(CacheJmxWrapperMBean.class, mbeanObjectName, MBeanServerLocator.locateJBoss());
            this.cache = mbean.getCache();
            this.optimistic = this.cache.getConfiguration().isNodeLockingOptimistic();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        String regionPrefix = properties.getProperty("hibernate.cache.region_prefix");
        if (this.optimistic) {
            return new OptimisticJBCCache(this.cache, regionName, regionPrefix);
        }
        return new JBCCache(this.cache, regionName, regionPrefix, TxUtil.getTransactionManager());
    }

    public boolean isOptimistic() {
        return this.optimistic;
    }
}

