/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jms.client.remoting.CallbackManager;
import org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener;
import org.jboss.jms.wireformat.JMSWireFormat;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.GUIDGenerator;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.util.id.GUID;

public class JMSRemotingConnection {
    public static final String CALLBACK_POLL_PERIOD_DEFAULT = "100";
    private static final Logger log = Logger.getLogger(JMSRemotingConnection.class);
    private Client client;
    private boolean clientPing;
    private InvokerLocator serverLocator;
    private CallbackManager callbackManager;
    private boolean strictTck;
    protected boolean failed = false;
    private ConsolidatedRemotingConnectionListener remotingConnectionListener;

    private static String getPropertySafely(String propName) {
        String prop = null;
        try {
            prop = System.getProperty(propName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prop;
    }

    public static Map createCallbackMetadata(boolean doPushCallbacks, Map metadata, InvokerLocator serverLocator) {
        if (metadata == null) {
            metadata = new HashMap<String, String>();
        }
        metadata.put("onewayThreadPool", "org.jboss.jms.server.remoting.DirectThreadPool");
        if (doPushCallbacks) {
            String propertyPort;
            metadata.put("clientSocketClass", "org.jboss.jms.client.remoting.ClientSocketWrapper");
            metadata.put("serverSocketClass", "org.jboss.jms.server.remoting.ServerSocketWrapper");
            String bindAddress = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.bind.address");
            if (bindAddress != null) {
                metadata.put("callbackServerHost", bindAddress);
            }
            if ((propertyPort = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.bind.port")) != null) {
                metadata.put("callbackServerPort", propertyPort);
            }
            Map params = serverLocator.getParameters();
            int maxPoolSize = 50;
            if (params != null) {
                String val = (String)params.get("clientMaxPoolSize");
                maxPoolSize = Integer.valueOf(val);
            }
            metadata.put("clientMaxPoolSize", String.valueOf(maxPoolSize));
            String protocol = serverLocator.getProtocol();
            if ("bisocket".equals(protocol) || "sslbisocket".equals(protocol)) {
                metadata.put("isCallbackServer", "true");
                if (propertyPort == null) {
                    String guid = new GUID().toString();
                    int hash = guid.hashCode();
                    while (hash <= 0) {
                        if (hash == 0) {
                            guid = GUIDGenerator.generateGUID();
                            hash = guid.hashCode();
                        }
                        if (hash >= 0) continue;
                        if (hash == Integer.MIN_VALUE) {
                            hash = Integer.MAX_VALUE;
                            continue;
                        }
                        hash = -hash;
                    }
                    metadata.put("callbackServerPort", Integer.toString(hash));
                    metadata.put("guid", guid);
                }
            }
        } else {
            String callbackPollPeriod = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.pollPeriod");
            if (callbackPollPeriod == null && (callbackPollPeriod = (String)serverLocator.getParameters().get("callbackPollPeriod")) == null) {
                callbackPollPeriod = CALLBACK_POLL_PERIOD_DEFAULT;
            }
            metadata.put("callbackPollPeriod", callbackPollPeriod);
            String reportPollingStatistics = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.reportPollingStatistics");
            if (reportPollingStatistics != null) {
                metadata.put("reportStatistics", reportPollingStatistics);
            }
        }
        return metadata;
    }

    public static void addInvokerCallbackHandler(Object configurer, Client client, Map initialMetadata, InvokerLocator serverLocator, InvokerCallbackHandler invokerCallbackHandler) throws Throwable {
        String protocol = serverLocator.getProtocol();
        boolean isBisocket = "bisocket".equals(protocol) || "sslbisocket".equals(protocol);
        boolean isSocket = "socket".equals(protocol) || "sslsocket".equals(protocol);
        boolean doPushCallbacks = isBisocket || isSocket;
        Map metadata = JMSRemotingConnection.createCallbackMetadata(doPushCallbacks, initialMetadata, serverLocator);
        if (doPushCallbacks) {
            log.trace(configurer + " is doing push callbacks");
            client.addListener(invokerCallbackHandler, metadata, null, true);
        } else {
            log.trace(configurer + " is simulating push callbacks");
            client.addListener(invokerCallbackHandler, metadata);
        }
    }

    public JMSRemotingConnection(String serverLocatorURI, boolean clientPing, boolean strictTck) throws Exception {
        this.serverLocator = new InvokerLocator(serverLocatorURI);
        this.clientPing = clientPing;
        this.strictTck = strictTck;
        log.trace(this + " created");
    }

    public void start() throws Throwable {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("enableLease", String.valueOf(this.clientPing));
        this.client = new Client(this.serverLocator, config);
        this.client.setSubsystem("JMS");
        if (log.isTraceEnabled()) {
            log.trace(this + " created client");
        }
        this.callbackManager = new CallbackManager();
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                JMSRemotingConnection.this.client.connect();
                return null;
            }
        });
        this.client.setMarshaller(new JMSWireFormat());
        this.client.setUnMarshaller(new JMSWireFormat());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("datatype", "jms");
        JMSRemotingConnection.addInvokerCallbackHandler(this, this.client, metadata, this.serverLocator, this.callbackManager);
        log.trace(this + " started");
    }

    public void stop() {
        log.trace(this + " stop");
        try {
            this.client.removeListener(this.callbackManager);
        }
        catch (Throwable ignore) {
            log.trace(this + " failed to cleanly remove callback manager from the client", ignore);
        }
        try {
            this.client.disconnect();
        }
        catch (Throwable ignore) {
            log.trace(this + " failed to disconnect the client", ignore);
        }
        this.client = null;
        log.trace(this + " closed");
    }

    public Client getRemotingClient() {
        return this.client;
    }

    public CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    public boolean isStrictTck() {
        return this.strictTck;
    }

    public synchronized boolean isFailed() {
        return this.failed;
    }

    public synchronized void setFailed() {
        this.failed = true;
        try {
            this.client.setDisconnectTimeout(0);
        }
        catch (Throwable ignore) {
            log.trace(this + " failed to set disconnect timeout", ignore);
        }
        this.stop();
    }

    public synchronized boolean addConnectionListener(ConsolidatedRemotingConnectionListener listener) {
        if (this.remotingConnectionListener != null) {
            return false;
        }
        this.client.addConnectionListener(listener);
        this.remotingConnectionListener = listener;
        return true;
    }

    public synchronized void addPlainConnectionListener(ConnectionListener listener) {
        this.client.addConnectionListener(listener);
    }

    public synchronized void removePlainConnectionListener(ConnectionListener listener) {
        this.client.removeConnectionListener(listener);
    }

    public synchronized ConsolidatedRemotingConnectionListener getConnectionListener() {
        return this.remotingConnectionListener;
    }

    public synchronized ConsolidatedRemotingConnectionListener removeConnectionListener() {
        if (this.remotingConnectionListener == null) {
            return null;
        }
        this.client.removeConnectionListener(this.remotingConnectionListener);
        log.trace(this + " removed consolidated connection listener from " + this.client);
        ConsolidatedRemotingConnectionListener toReturn = this.remotingConnectionListener;
        this.remotingConnectionListener = null;
        return toReturn;
    }

    public String toString() {
        return "JMSRemotingConnection[" + this.serverLocator.getLocatorURI() + "]";
    }
}

