/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.TableMetaType;
import org.jboss.metatype.api.values.TableValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableTableMetaType
extends AbstractMetaType
implements TableMetaType {
    private static final long serialVersionUID = 5791103660662775558L;
    private CompositeMetaType rowType;
    private List<String> indexNames;
    private transient int cachedHashCode = Integer.MIN_VALUE;
    private transient String cachedToString = null;

    public ImmutableTableMetaType(String typeName, String description, CompositeMetaType rowType, String[] indexNames) {
        super(TableValue.class.getName(), typeName, description);
        if (rowType == null) {
            throw new IllegalArgumentException("null rowType");
        }
        if (indexNames == null || indexNames.length == 0) {
            throw new IllegalArgumentException("null or empty indexNames");
        }
        this.rowType = rowType;
        this.indexNames = new ArrayList<String>();
        for (int i = 0; i < indexNames.length; ++i) {
            if (indexNames[i] == null) {
                throw new IllegalArgumentException("null index name " + i);
            }
            String indexName = indexNames[i].trim();
            if (indexName.length() == 0) {
                throw new IllegalArgumentException("empty index name " + i);
            }
            if (!rowType.containsItem(indexName)) {
                throw new IllegalArgumentException("no item name " + indexName);
            }
            this.indexNames.add(indexName);
        }
    }

    @Override
    public CompositeMetaType getRowType() {
        return this.rowType;
    }

    @Override
    public List<String> getIndexNames() {
        return Collections.unmodifiableList(this.indexNames);
    }

    @Override
    public boolean isTable() {
        return true;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof TableValue)) {
            return false;
        }
        TableMetaType other = ((TableValue)obj).getMetaType();
        return this.equals(other);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TableMetaType)) {
            return false;
        }
        TableMetaType other = (TableMetaType)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        if (!this.getRowType().equals(other.getRowType())) {
            return false;
        }
        Iterator<String> thisNames = this.getIndexNames().iterator();
        Iterator<String> otherNames = other.getIndexNames().iterator();
        while (thisNames.hasNext() && otherNames.hasNext()) {
            String otherName;
            String thisName = thisNames.next();
            if (thisName.equals(otherName = otherNames.next())) continue;
            return false;
        }
        return !thisNames.hasNext() && !otherNames.hasNext();
    }

    public int hashCode() {
        if (this.cachedHashCode != Integer.MIN_VALUE) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getTypeName().hashCode();
        this.cachedHashCode += this.getRowType().hashCode();
        Iterator<String> i = this.indexNames.iterator();
        while (i.hasNext()) {
            this.cachedHashCode += i.next().hashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(": typeName=[");
        buffer.append(this.getTypeName());
        buffer.append("] rowType=[");
        buffer.append(this.getRowType());
        buffer.append("] indexNames=[");
        Iterator<String> thisNames = this.getIndexNames().iterator();
        while (thisNames.hasNext()) {
            buffer.append((Object)thisNames.next());
            if (!thisNames.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }
}

