/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.utility;

import java.io.Serializable;
import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;

public class ShutDownGate
implements Serializable {
    private static final long serialVersionUID = 2L;
    private int numberOfUsers;
    private boolean shuttingDown;

    public ShutDownGate() {
        this.reset();
    }

    public void reset() {
        this.numberOfUsers = 0;
        this.shuttingDown = false;
    }

    public synchronized void check() throws ShuttingDownException {
        if (this.shuttingDown) {
            throw new ShuttingDownException();
        }
    }

    public synchronized boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public synchronized void enter() throws ShuttingDownException {
        if (this.shuttingDown) {
            throw new ShuttingDownException();
        }
        ++this.numberOfUsers;
    }

    public synchronized void leave() {
        if (this.numberOfUsers <= 0) {
            throw new Error("ShutDownGate: number of Users <= 0");
        }
        if (--this.numberOfUsers == 0) {
            this.notifyAll();
        }
    }

    public synchronized void shutDown() {
        this.shuttingDown = true;
        while (this.numberOfUsers > 0) {
            try {
                System.out.println("shutdown(): numberOfUsers == " + this.numberOfUsers);
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

