/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.strategy;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.QueryMetaData;
import org.jboss.util.Classes;
import org.jboss.verifier.strategy.AbstractVerifier;
import org.jboss.verifier.strategy.EJBVerifier11;
import org.jboss.verifier.strategy.VerificationContext;

public abstract class AbstractEJB2xVerifier
extends AbstractVerifier {
    protected EJBVerifier11 cmp1XVerifier;
    protected Class bean;
    protected Class home;
    protected Class remote;
    protected Class localHome;
    protected Class local;
    protected Class serviceEndpointInterface;

    public AbstractEJB2xVerifier(VerificationContext context) {
        super(context);
        this.cmp1XVerifier = new EJBVerifier11(context);
    }

    public boolean isCreateMethod(Method m) {
        return m.getName().startsWith("create");
    }

    public boolean isEjbCreateMethod(Method m) {
        return m.getName().startsWith("ejbCreate");
    }

    public boolean isEjbRemoveMethod(Method m) {
        return m.getName().startsWith("ejbRemove");
    }

    public boolean isEjbSelectMethod(Method m) {
        return m.getName().startsWith("ejbSelect");
    }

    public boolean isEjbHomeMethod(Method m) {
        return m.getName().startsWith("ejbHome");
    }

    public boolean hasRemoteInterface(Class c) {
        return this.isAssignableFrom("java.rmi.Remote", c);
    }

    public Iterator getEjbSelectMethods(Class c) {
        LinkedList<Method> selects = new LinkedList<Method>();
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isEjbSelectMethod(method[i])) continue;
            selects.add(method[i]);
        }
        return selects.iterator();
    }

    public boolean hasEJBRemoveMethod(Class c) {
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isEjbRemoveMethod(method[i])) continue;
            return true;
        }
        return false;
    }

    public Iterator getEJBRemoveMethods(Class c) {
        LinkedList<Method> ejbRemoves = new LinkedList<Method>();
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isEjbRemoveMethod(method[i])) continue;
            ejbRemoves.add(method[i]);
        }
        return ejbRemoves.iterator();
    }

    public Iterator getHomeMethods(Class c) {
        LinkedList<Method> homes = new LinkedList<Method>();
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (this.isCreateMethod(method[i]) || this.isFinderMethod(method[i])) continue;
            homes.add(method[i]);
        }
        return homes.iterator();
    }

    public Iterator getEjbHomeMethods(Class c) {
        LinkedList<Method> homes = new LinkedList<Method>();
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isEjbHomeMethod(method[i])) continue;
            homes.add(method[i]);
        }
        return homes.iterator();
    }

    protected boolean hasMatchingQuery(Method m, EntityMetaData e) {
        boolean result = false;
        Iterator<QueryMetaData> qIt = e.getQueries();
        while (qIt.hasNext()) {
            QueryMetaData qmd = qIt.next();
            if (!qmd.getMethodName().equals(m.getName())) continue;
            Class<?>[] methodParameter = m.getParameterTypes();
            Class[] queryParameter = null;
            try {
                queryParameter = Classes.convertToJavaClasses(qmd.getMethodParams(), this.classloader);
            }
            catch (ClassNotFoundException cnfe) {
                continue;
            }
            if (methodParameter.length != queryParameter.length) continue;
            boolean parametersMatch = true;
            for (int i = 0; i < methodParameter.length; ++i) {
                if (methodParameter[i].equals(queryParameter[i])) continue;
                parametersMatch = false;
                break;
            }
            if (!parametersMatch) continue;
            result = true;
            break;
        }
        return result;
    }
}

