/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;

public class XSModelTypes
extends WSDLTypes {
    private static final Logger log = Logger.getLogger(XSModelTypes.class);
    private JBossXSModel schemaModel = new JBossXSModel();

    public void addSchemaModel(String nsURI, JBossXSModel schema) {
        if (nsURI == null) {
            log.trace("nsURI passed to addSchemaModel is null. Replacing Schema Model");
            this.schemaModel = schema;
        } else {
            this.schemaModel.merge(schema);
        }
    }

    public JBossXSModel getSchemaModel() {
        return this.schemaModel;
    }

    public QName getXMLType(QName xmlName) {
        QName xmlType = null;
        String nsURI = xmlName.getNamespaceURI();
        String localPart = xmlName.getLocalPart();
        XSElementDeclaration xsel = this.schemaModel.getElementDeclaration(localPart, nsURI);
        if (xsel != null) {
            XSTypeDefinition xstype = xsel.getTypeDefinition();
            if (xstype == null) {
                throw new WSException("Cannot obtain XSTypeDefinition for: " + xmlName);
            }
            xmlType = !xstype.getAnonymous() ? new QName(xstype.getNamespace(), xstype.getName()) : new QName(xstype.getNamespace(), ">" + localPart);
        }
        return xmlType;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("WSDLTypes:\n");
        buffer.append(this.schemaModel != null ? this.schemaModel.serialize() : "<schema/>");
        return buffer.toString();
    }
}

