/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Dom2Sax {
    public static void dom2sax(Element e, ContentHandler ch) throws SAXException {
        if (e == null) {
            throw new IllegalArgumentException("The element argument must not be null!");
        }
        ch.startDocument();
        Dom2Sax.process(e, ch, new NamespaceRegistry());
        ch.endDocument();
    }

    private static void process(Element e, ContentHandler ch, NamespaceRegistry nsReg) throws SAXException {
        String prefix;
        String ns;
        String localName;
        AttributesImpl attrs = new AttributesImpl();
        List startedPrefixes = Collections.EMPTY_LIST;
        NamedNodeMap domAttrs = e.getAttributes();
        if (domAttrs != null && domAttrs.getLength() > 0) {
            String prefix2;
            String attrLocal;
            String attrNs;
            Attr attr;
            int i;
            for (i = 0; i < domAttrs.getLength(); ++i) {
                String attrPrefix;
                attr = (Attr)domAttrs.item(i);
                attrNs = attr.getNamespaceURI();
                attrLocal = attr.getLocalName();
                if (attrLocal == null) {
                    attrLocal = attr.getNodeName();
                }
                if (attrNs == null || !Dom2Sax.isXmlns(attrNs)) continue;
                if ("xmlns".equals(attrLocal)) {
                    prefix2 = "";
                    attrPrefix = "";
                } else {
                    prefix2 = attrLocal;
                    attrPrefix = "xmlns";
                }
                String attrVal = attr.getValue();
                nsReg.addPrefixMapping(prefix2, attrVal);
                ch.startPrefixMapping(prefix2, attrVal);
                startedPrefixes = Dom2Sax.add(startedPrefixes, prefix2);
                attrs.addAttribute(attrNs, attrLocal, Dom2Sax.buildQName(attrPrefix, attrLocal), null, attrVal);
            }
            for (i = 0; i < domAttrs.getLength(); ++i) {
                attr = (Attr)domAttrs.item(i);
                attrNs = attr.getNamespaceURI();
                attrLocal = attr.getLocalName();
                if (attrLocal == null) {
                    attrLocal = attr.getNodeName();
                }
                if (attrNs == null) {
                    attrNs = "";
                }
                if (Dom2Sax.isXmlns(attrNs)) continue;
                prefix2 = nsReg.getPrefix(attrNs);
                if (prefix2 == null && attrNs.length() > 0) {
                    prefix2 = attrLocal + "_ns";
                    nsReg.addPrefixMapping(prefix2, attrNs);
                    ch.startPrefixMapping(prefix2, attrNs);
                    startedPrefixes = Dom2Sax.add(startedPrefixes, prefix2);
                    attrs.addAttribute("http://www.w3.org/2001/XMLSchema", prefix2, "xmlns:" + prefix2, null, attrNs);
                }
                attrs.addAttribute(attrNs, attrLocal, Dom2Sax.buildQName(prefix2, attrLocal), null, attr.getValue());
            }
        }
        if ((localName = e.getLocalName()) == null) {
            localName = e.getNodeName();
        }
        if ((ns = e.getNamespaceURI()) == null) {
            ns = "";
        }
        if ((prefix = nsReg.getPrefix(ns)) == null && ns.length() > 0) {
            prefix = localName + "_ns";
            nsReg.addPrefixMapping(prefix, ns);
            ch.startPrefixMapping(prefix, ns);
            startedPrefixes = Dom2Sax.add(startedPrefixes, prefix);
            attrs.addAttribute("http://www.w3.org/2001/XMLSchema", prefix, "xmlns:" + prefix, null, ns);
        }
        String qName = Dom2Sax.buildQName(prefix, localName);
        ch.startElement(ns, localName, qName, attrs);
        NodeList childNodes = e.getChildNodes();
        if (childNodes != null && childNodes.getLength() > 0) {
            block8: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                switch (node.getNodeType()) {
                    case 1: {
                        Dom2Sax.process((Element)node, ch, nsReg);
                        continue block8;
                    }
                    case 3: 
                    case 4: {
                        String value = node.getNodeValue();
                        ch.characters(value.toCharArray(), 0, value.length());
                        continue block8;
                    }
                    case 5: {
                        String ref = '&' + node.getNodeName() + ';';
                        ch.characters(ref.toCharArray(), 0, ref.length());
                        continue block8;
                    }
                    case 6: {
                        ch.skippedEntity(node.getNodeName());
                    }
                }
            }
        }
        ch.endElement(ns, localName, qName);
        if (startedPrefixes.size() > 0) {
            for (int i = startedPrefixes.size() - 1; i >= 0; --i) {
                String pref = (String)startedPrefixes.get(i);
                nsReg.removePrefixMapping(pref);
                ch.endPrefixMapping(pref);
            }
        }
    }

    private static boolean isXmlns(String ns) {
        return ns.startsWith("http://www.w3.org/2000/xmlns");
    }

    private static String buildQName(String prefix, String localName) {
        return prefix == null || prefix.length() == 0 ? localName : prefix + ':' + localName;
    }

    private static List add(List list2, Object o) {
        switch (list2.size()) {
            case 0: {
                list2 = Collections.singletonList(o);
                break;
            }
            case 1: {
                list2 = new ArrayList<Object>(list2);
            }
            default: {
                list2.add(o);
            }
        }
        return list2;
    }
}

