/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.PersistenceRecord;
import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.LogWriteStateManager;

public class TxLogWritePersistenceRecord
extends PersistenceRecord {
    public TxLogWritePersistenceRecord(OutputObjectState state, ObjectStore store, StateManager sm) {
        super(state, store, sm);
    }

    public int typeIs() {
        return 112;
    }

    public ClassName className() {
        return ArjunaNames.Implementation_AbstractRecord_TxLogPersistenceRecord();
    }

    public int topLevelCommit() {
        boolean result = false;
        LogWriteStateManager sm = null;
        boolean writeToLog = true;
        try {
            sm = (LogWriteStateManager)this.objectAddr;
            writeToLog = sm.writeOptimisation();
        }
        catch (ClassCastException ex) {
            writeToLog = false;
        }
        if (this.store != null) {
            try {
                if (this.shadowMade) {
                    result = this.store.commit_state(this.order(), super.getTypeOfObject());
                    if (!result && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_2", new Object[]{this.order()});
                    }
                } else if (this.topLevelState != null) {
                    result = !writeToLog ? this.store.write_committed(this.order(), super.getTypeOfObject(), this.topLevelState) : true;
                }
            }
            catch (ObjectStoreException e) {
                result = false;
            }
        }
        if (!result) {
            // empty if block
        }
        super.forgetAction(true);
        return result ? 7 : 8;
    }

    public int topLevelPrepare() {
        int result = 1;
        StateManager sm = this.objectAddr;
        LogWriteStateManager lwsm = null;
        boolean writeToLog = true;
        try {
            lwsm = (LogWriteStateManager)sm;
            writeToLog = lwsm.writeOptimisation();
        }
        catch (ClassCastException ex) {
            writeToLog = false;
        }
        if (sm != null && this.store != null) {
            this.topLevelState = new OutputObjectState(sm.get_uid(), sm.type());
            if (writeToLog || !this.store.fullCommitNeeded() && sm.save_state(this.topLevelState, 1) && this.topLevelState.size() <= 4096) {
                if (PersistenceRecord.classicPrepare) {
                    OutputObjectState dummy = new OutputObjectState(Uid.nullUid(), null);
                    try {
                        this.store.write_uncommitted(sm.get_uid(), sm.type(), dummy);
                        result = 0;
                    }
                    catch (ObjectStoreException e) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_21", e);
                    }
                    dummy = null;
                } else {
                    result = 0;
                }
            } else if (sm.deactivate(this.store.getStoreName(), false)) {
                this.shadowMade = true;
                result = 0;
            } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_7");
            }
        } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_8");
        }
        return result;
    }

    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/TxLogPersistenceRecord";
    }

    public static AbstractRecord create() {
        return new TxLogWritePersistenceRecord();
    }

    protected TxLogWritePersistenceRecord() {
    }
}

