/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.Listener;
import com.arjuna.ats.internal.arjuna.recovery.WorkerService;
import java.io.IOException;
import java.net.ServerSocket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PeriodicRecovery
extends Thread {
    private static Vector _recoveryModules;
    private static int _backoffPeriod;
    private static int _recoveryPeriod;
    private static final int _defaultBackoffPeriod = 10;
    private static final int _defaultRecoveryPeriod = 120;
    private static boolean _terminate;
    private static SimpleDateFormat _theTimestamper;
    private static ServerSocket _socket;
    private static Listener _listener;
    private static WorkerService _workerService;

    public PeriodicRecovery(boolean threaded) {
        block3: {
            this.initialise();
            PeriodicRecovery.loadModules();
            try {
                _workerService = new WorkerService(this);
                _listener = new Listener(PeriodicRecovery.getServerSocket(), (Service)_workerService);
                _listener.setDaemon(true);
            }
            catch (Exception ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block3;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_9", new Object[]{ex});
            }
        }
        if (threaded) {
            this.start();
        }
        _listener.start();
    }

    public void shutdown() {
        _terminate = true;
        this.interrupt();
    }

    public static final ServerSocket getServerSocket() throws IOException {
        if (_socket == null) {
            int port;
            block4: {
                String tsmPortStr = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.recovery.recoveryPort");
                port = 0;
                if (tsmPortStr != null) {
                    try {
                        port = Integer.parseInt(tsmPortStr);
                    }
                    catch (Exception ex) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block4;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_8", new Object[]{ex});
                    }
                }
            }
            _socket = new ServerSocket(port);
        }
        return _socket;
    }

    public void run() {
        boolean finished = false;
        while (!(finished = this.doWork(true))) {
        }
    }

    public final boolean doWork(boolean periodic) {
        RecoveryModule m;
        boolean interrupted = false;
        tsLogger.arjLogger.info("Periodic recovery - first pass <" + _theTimestamper.format(new Date()) + ">");
        Enumeration modules = _recoveryModules.elements();
        while (modules.hasMoreElements()) {
            m = (RecoveryModule)modules.nextElement();
            m.periodicWorkFirstPass();
            if (!tsLogger.arjLogger.isDebugEnabled()) continue;
            tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
        }
        if (interrupted) {
            interrupted = false;
            _workerService.signalDone();
        }
        try {
            Thread.sleep(_backoffPeriod * 1000);
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        if (_terminate) {
            return true;
        }
        tsLogger.arjLogger.info("Periodic recovery - second pass <" + _theTimestamper.format(new Date()) + ">");
        modules = _recoveryModules.elements();
        while (modules.hasMoreElements()) {
            m = (RecoveryModule)modules.nextElement();
            m.periodicWorkSecondPass();
            if (!tsLogger.arjLogger.isDebugEnabled()) continue;
            tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
        }
        try {
            if (!interrupted && periodic) {
                Thread.sleep(_recoveryPeriod * 1000);
            }
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        return _terminate;
    }

    public final void addModule(RecoveryModule module) {
        _recoveryModules.add(module);
    }

    public final Vector getModules() {
        return _recoveryModules;
    }

    private static final void loadModules() {
        Properties properties = arjPropertyManager.propertyManager.getProperties();
        if (properties != null) {
            String attrName;
            Vector<String> moduleNames = new Vector<String>();
            Enumeration<Object> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                int position;
                attrName = (String)names.nextElement();
                if (!attrName.startsWith("com.arjuna.ats.arjuna.recovery.recoveryExtension")) continue;
                for (position = 0; position < moduleNames.size() && attrName.compareTo((String)moduleNames.elementAt(position)) > 0; ++position) {
                }
                moduleNames.add(position, attrName);
            }
            names = moduleNames.elements();
            while (names.hasMoreElements()) {
                attrName = (String)names.nextElement();
                PeriodicRecovery.loadModule(properties.getProperty(attrName));
            }
        }
    }

    private static final void loadModule(String className) {
        block12: {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 1L, 2048L, "Loading recovery module " + className);
            }
            if (className == null) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_1");
                }
                return;
            }
            try {
                Class<?> c;
                block11: {
                    c = Thread.currentThread().getContextClassLoader().loadClass(className);
                    try {
                        RecoveryModule m = (RecoveryModule)c.newInstance();
                        _recoveryModules.add(m);
                    }
                    catch (ClassCastException e) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_2", new Object[]{className});
                        }
                    }
                    catch (IllegalAccessException iae) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_3", new Object[]{iae});
                        }
                    }
                    catch (InstantiationException ie) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block11;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_4", new Object[]{ie});
                    }
                }
                c = null;
            }
            catch (ClassNotFoundException cnfe) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block12;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_5", new Object[]{className});
            }
        }
    }

    private final void initialise() {
        _recoveryModules = new Vector();
        _terminate = false;
    }

    static {
        block9: {
            block8: {
                _recoveryModules = null;
                _backoffPeriod = 0;
                _recoveryPeriod = 0;
                _terminate = false;
                _theTimestamper = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
                _socket = null;
                _listener = null;
                _workerService = null;
                _recoveryPeriod = 120;
                String recoveryPeriodString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.periodicRecoveryPeriod");
                if (recoveryPeriodString != null) {
                    try {
                        Integer recoveryPeriodInteger = new Integer(recoveryPeriodString);
                        _recoveryPeriod = recoveryPeriodInteger;
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug(16L, 1L, 2048L, "com.arjuna.ats.arjuna.recovery.PeriodicRecovery: Recovery period set to " + _recoveryPeriod + " seconds");
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block8;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_6", new Object[]{"com.arjuna.ats.arjuna.recovery.periodicRecoveryPeriod", recoveryPeriodString});
                    }
                }
            }
            _backoffPeriod = 10;
            String backoffPeriodString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.recoveryBackoffPeriod");
            if (backoffPeriodString != null) {
                try {
                    Integer backoffPeriodInteger = new Integer(backoffPeriodString);
                    _backoffPeriod = backoffPeriodInteger;
                    if (tsLogger.arjLogger.isDebugEnabled()) {
                        tsLogger.arjLogger.debug(16L, 1L, 2048L, "PeriodicRecovery: Backoff period set to " + _backoffPeriod + " seconds");
                    }
                }
                catch (NumberFormatException e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block9;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_7", new Object[]{"com.arjuna.ats.arjuna.recovery.recoveryBackoffPeriod", backoffPeriodString});
                }
            }
        }
    }
}

