/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.net.URL;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectModelFactoryDeployer<T>
extends AbstractVFSParsingDeployer<T> {
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private boolean useSchemaValidation = true;
    private boolean useValidation = true;

    public ObjectModelFactoryDeployer(Class<T> output) {
        super(output);
    }

    public boolean isUseSchemaValidation() {
        return this.useSchemaValidation;
    }

    public void setUseSchemaValidation(boolean useSchemaValidation) {
        this.useSchemaValidation = useSchemaValidation;
    }

    public boolean isUseValidation() {
        return this.useValidation;
    }

    public void setUseValidation(boolean useValidation) {
        this.useValidation = useValidation;
    }

    @Override
    protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        unmarshaller.setSchemaValidation(this.isUseSchemaValidation());
        unmarshaller.setValidation(this.isUseValidation());
        Object parsed = null;
        try {
            ObjectModelFactory factory = this.getObjectModelFactory(root);
            URL url = file.toURL();
            parsed = unmarshaller.unmarshal(url.toString(), factory, root);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Error parsing meta data " + file.getPathName(), t);
        }
        if (parsed == null) {
            throw new DeploymentException("The xml " + file.getPathName() + " is not well formed!");
        }
        return this.getOutput().cast(parsed);
    }

    protected abstract ObjectModelFactory getObjectModelFactory(T var1);
}

