/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.jboss.ServiceModuleMetaData;
import org.jboss.metadata.ear.spec.AbstractModule;
import org.jboss.metadata.ear.spec.ConnectorModuleMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.EjbModuleMetaData;
import org.jboss.metadata.ear.spec.JavaModuleMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class EARStructure
extends AbstractStructureDeployer {
    public static final VirtualFileFilter DEFAULT_EAR_LIB_FILTER = new SuffixMatchFilter(".jar");
    private VirtualFileFilter earLibFilter = DEFAULT_EAR_LIB_FILTER;
    private SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();

    public EARStructure() {
        this.setRelativeOrder(1000);
    }

    public VirtualFileFilter getEarLibFilter() {
        return this.earLibFilter;
    }

    public void setEarLibFilter(VirtualFileFilter earLibFilter) {
        if (earLibFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.earLibFilter = earLibFilter;
    }

    public SchemaBindingResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(SchemaBindingResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) {
        boolean valid;
        ContextInfo context = null;
        boolean trace = this.log.isTraceEnabled();
        try {
            ModulesMetaData modules;
            JBossAppMetaData appMetaData;
            boolean scan;
            block28: {
                String libDir;
                InputStream in;
                if (file.isLeaf() || !file.getName().endsWith(".ear")) {
                    return false;
                }
                context = this.createContext(file, "META-INF", metaData);
                VirtualFile applicationXml = this.getMetaDataFile(file, "META-INF/application.xml");
                VirtualFile jbossAppXml = this.getMetaDataFile(file, "META-INF/jboss-app.xml");
                scan = true;
                UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
                Unmarshaller unmarshaller = unmarshallerFactory.newUnmarshaller();
                EarMetaData specMetaData = null;
                appMetaData = null;
                if (applicationXml != null) {
                    in = applicationXml.openStream();
                    try {
                        specMetaData = (EarMetaData)unmarshaller.unmarshal(in, this.resolver);
                    }
                    finally {
                        in.close();
                    }
                    scan = false;
                }
                if (jbossAppXml != null) {
                    in = jbossAppXml.openStream();
                    try {
                        appMetaData = (JBossAppMetaData)unmarshaller.unmarshal(in, this.resolver);
                    }
                    finally {
                        in.close();
                    }
                }
                if (appMetaData == null) {
                    appMetaData = new JBossAppMetaData();
                }
                appMetaData.merge(appMetaData, specMetaData);
                String string = libDir = appMetaData.getLibraryDirectory() == null ? "lib" : appMetaData.getLibraryDirectory();
                if (trace) {
                    this.log.trace("Checking for ear lib directory: " + libDir);
                }
                try {
                    VirtualFile lib = file.findChild(libDir);
                    if (lib != null) {
                        if (trace) {
                            this.log.trace("Found ear lib directory: " + lib);
                        }
                        List<VirtualFile> archives = lib.getChildren(this.earLibFilter);
                        for (VirtualFile archive : archives) {
                            super.addClassPath(root, archive, true, true, context);
                            try {
                                if (archive.findChild("META-INF/persistence.xml") == null) continue;
                                this.log.trace(archive.getName() + " in ear lib directory has persistence units");
                                if (deployers.determineStructure(root, file, archive, metaData)) continue;
                                throw new RuntimeException(archive.getName() + " in lib directory has persistence.xml but is not a recognized deployment, .ear: " + file.getName());
                            }
                            catch (IOException e) {
                                if (!trace) continue;
                                this.log.trace(archive.getPathName() + " does not contain META-INF/persistence.xml");
                            }
                        }
                    }
                }
                catch (IOException ignored) {
                    if (!trace) break block28;
                    this.log.trace("Ignoring exception while searching for lib dir", ignored);
                }
            }
            super.addClassPath(root, file, false, true, context);
            if (scan) {
                this.scanEar(file, appMetaData);
            }
            if ((modules = appMetaData.getModules()) != null) {
                for (ModuleMetaData mod : modules) {
                    String fileName = mod.getFileName();
                    if (fileName == null || (fileName = fileName.trim()).length() <= 0) continue;
                    try {
                        VirtualFile module = file.findChild(fileName);
                        if (module == null) {
                            throw new RuntimeException(fileName + " module listed in application.xml does not exist within .ear " + file.getName());
                        }
                        if (deployers.determineStructure(root, file, module, metaData)) continue;
                        throw new RuntimeException(fileName + " module listed in application.xml is not a recognized deployment, .ear: " + file.getName());
                    }
                    catch (IOException ignored) {
                        throw new RuntimeException(fileName + " module listed in application.xml does not exist within .ear " + file.getName(), ignored);
                    }
                }
            }
            valid = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Error determining structure: " + file.getName(), e);
        }
        return valid;
    }

    private void scanEar(VirtualFile root, JBossAppMetaData appMetaData) throws IOException {
        List<VirtualFile> archives = root.getChildren();
        if (archives != null) {
            String earPath = root.getPathName();
            ModulesMetaData modules = appMetaData.getModules();
            if (modules == null) {
                modules = new ModulesMetaData();
                appMetaData.setModules(modules);
            }
            for (VirtualFile vfArchive : archives) {
                String filename = this.earRelativePath(earPath, vfArchive.getPathName());
                ModuleMetaData moduleMetaData = appMetaData.getModule(filename);
                int type = this.typeFromSuffix(filename, vfArchive);
                if (type < 0 || moduleMetaData != null) continue;
                moduleMetaData = new ModuleMetaData();
                AbstractModule module = null;
                switch (type) {
                    case 0: {
                        module = new EjbModuleMetaData();
                        break;
                    }
                    case 2: {
                        module = new JavaModuleMetaData();
                        break;
                    }
                    case 3: {
                        module = new ConnectorModuleMetaData();
                        break;
                    }
                    case 4: 
                    case 5: {
                        module = new ServiceModuleMetaData();
                        break;
                    }
                    case 1: {
                        module = new WebModuleMetaData();
                    }
                }
                module.setFileName(filename);
                moduleMetaData.setValue(module);
                modules.add(moduleMetaData);
            }
        }
    }

    private int typeFromSuffix(String path, VirtualFile archive) throws IOException {
        int type = -1;
        if (path.endsWith(".war")) {
            type = 1;
        } else if (path.endsWith(".rar")) {
            type = 3;
        } else if (path.endsWith(".har")) {
            type = 5;
        } else if (path.endsWith(".sar")) {
            type = 4;
        } else if (path.endsWith(".jar")) {
            Manifest mf;
            Attributes attrs;
            VirtualFile mfFile = this.getMetaDataFile(archive, "META-INF/MANIFEST.MF");
            VirtualFile clientXml = this.getMetaDataFile(archive, "META-INF/application-client.xml");
            VirtualFile ejbXml = this.getMetaDataFile(archive, "META-INF/ejb-jar.xml");
            VirtualFile jbossXml = this.getMetaDataFile(archive, "META-INF/jboss.xml");
            type = clientXml != null ? 2 : (mfFile != null ? ((attrs = (mf = VFSUtils.readManifest(mfFile)).getMainAttributes()).containsKey(Attributes.Name.MAIN_CLASS) ? 2 : 0) : (ejbXml != null || jbossXml != null ? 0 : 0));
        }
        return type;
    }

    private String earRelativePath(String earPath, String pathName) {
        StringBuilder tmp = new StringBuilder(pathName);
        tmp.delete(0, earPath.length());
        return tmp.toString();
    }

    private VirtualFile getMetaDataFile(VirtualFile file, String path) {
        VirtualFile metaFile = null;
        try {
            metaFile = file.findChild(path);
        }
        catch (IOException e) {
            // empty catch block
        }
        return metaFile;
    }
}

