/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaDataWrapper;

public class StandardJBossMetaDataDeployer
extends AbstractDeployer {
    public static final String RAW_ATTACHMENT_NAME = "raw." + JBossMetaData.class.getName();

    public StandardJBossMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(JBossMetaData.class);
        this.addInput("standardjboss.xml");
        this.addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        this.setOutput(JBossMetaData.class);
        this.addOutput(RAW_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        JBossMetaData metaData = unit.getAttachment(JBossMetaData.class);
        JBossMetaData stdMetaData = unit.getAttachment("standardjboss.xml", JBossMetaData.class);
        if (metaData == null || stdMetaData == null) {
            return;
        }
        JBossMetaDataWrapper wrapper = new JBossMetaDataWrapper(metaData, stdMetaData);
        unit.getTransientManagedObjects().addAttachment(JBossMetaData.class, wrapper);
        unit.addAttachment(RAW_ATTACHMENT_NAME, metaData, JBossMetaData.class);
    }
}

