/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.logging.Logger;

public final class JDBCStopCommand {
    private final JDBCEntityPersistenceStore manager;
    private final JDBCAbstractEntityBridge entity;
    private final JDBCEntityMetaData entityMetaData;
    private final Logger log;

    public JDBCStopCommand(JDBCEntityPersistenceStore manager) {
        this.manager = manager;
        this.entity = manager.getEntityBridge();
        this.entityMetaData = this.entity.getMetaData();
        this.log = Logger.getLogger(this.getClass().getName() + "." + manager.getMetaData().getName());
    }

    public boolean execute() {
        boolean dropped;
        boolean success = true;
        JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCAbstractCMRFieldBridge cmrField = cmrFields[i];
            JDBCRelationMetaData relationMetaData = cmrField.getMetaData().getRelationMetaData();
            if (!relationMetaData.isTableMappingStyle() || relationMetaData.isTableDropped() || !relationMetaData.getRemoveTable()) continue;
            boolean dropped2 = this.dropTable(relationMetaData.getDataSource(), cmrField.getQualifiedTableName());
            if (!dropped2) {
                success = false;
                continue;
            }
            relationMetaData.setTableDropped();
        }
        if (this.entityMetaData.getRemoveTable() && !(dropped = this.dropTable(this.entity.getDataSource(), this.entity.getQualifiedTableName()))) {
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private boolean dropTable(DataSource dataSource, String qualifiedTableName) {
        boolean success;
        block20: {
            ResultSet rs;
            Connection con;
            block19: {
                boolean bl;
                con = null;
                rs = null;
                String schema = SQLUtil.getSchema(qualifiedTableName);
                String tableName = schema != null ? SQLUtil.getTableNameWithoutSchema(qualifiedTableName) : qualifiedTableName;
                try {
                    con = dataSource.getConnection();
                    DatabaseMetaData dmd = con.getMetaData();
                    rs = dmd.getTables(con.getCatalog(), schema, tableName, null);
                    if (rs.next()) break block19;
                    bl = true;
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    JDBCUtil.safeClose(rs);
                    JDBCUtil.safeClose(con);
                    throw throwable;
                }
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(con);
                {
                    return bl;
                    catch (SQLException e) {
                        this.log.debug("Error getting database metadata for DROP TABLE command.  DROP TABLE will not be executed. ", e);
                        boolean bl2 = true;
                        Object var11_14 = null;
                        JDBCUtil.safeClose(rs);
                        JDBCUtil.safeClose(con);
                        return bl2;
                    }
                }
            }
            Object var11_13 = null;
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(con);
            TransactionManager tm = this.manager.getContainer().getTransactionManager();
            Transaction oldTransaction = null;
            try {
                oldTransaction = tm.suspend();
            }
            catch (Exception e) {
                this.log.error("Could not suspend current transaction before drop table. '" + qualifiedTableName + "' will not be dropped.", e);
            }
            Statement statement = null;
            try {
                con = dataSource.getConnection();
                statement = con.createStatement();
                String sql = "DROP TABLE " + qualifiedTableName;
                this.log.debug("Executing SQL: " + sql);
                statement.executeUpdate(sql);
                success = true;
                Object var13_21 = null;
            }
            catch (Throwable throwable) {
                Object var13_22 = null;
                JDBCUtil.safeClose(statement);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
            JDBCUtil.safeClose(statement);
            JDBCUtil.safeClose(con);
            Object var15_24 = null;
            try {
                if (oldTransaction != null) {
                    tm.resume(oldTransaction);
                }
                break block20;
            }
            catch (Exception e2) {
                this.log.error("Could not reattach original transaction after drop table");
            }
            break block20;
            {
                catch (Exception e) {
                    this.log.debug("Could not drop table " + qualifiedTableName + ": " + e.getMessage());
                    success = false;
                    Object var15_25 = null;
                    try {
                        if (oldTransaction != null) {
                            tm.resume(oldTransaction);
                        }
                        break block20;
                    }
                    catch (Exception e2) {
                        this.log.error("Could not reattach original transaction after drop table");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_26 = null;
                try {
                    if (oldTransaction != null) {
                        tm.resume(oldTransaction);
                    }
                }
                catch (Exception e2) {
                    this.log.error("Could not reattach original transaction after drop table");
                }
                throw throwable;
            }
        }
        return success;
    }
}

