/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.security.JaccPolicyUtil;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.cache.CacheFactoryRegistry;
import org.jboss.ejb3.cache.persistence.PersistenceManagerFactoryRegistry;
import org.jboss.ejb3.deployers.Ejb3JBoss5Deployment;
import org.jboss.ejb3.deployers.JBoss5DeploymentScope;
import org.jboss.ejb3.deployers.JBoss5DeploymentUnit;
import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitsMetaData;
import org.jboss.ejb3.pool.PoolFactoryRegistry;
import org.jboss.ejb3.remoting.RemoteProxyFactoryRegistry;
import org.jboss.kernel.Kernel;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Deployer
extends AbstractVFSRealDeployer {
    private Set<String> allowedSuffixes;
    private Properties defaultPersistenceProperties;
    private boolean deploymentDescriptorRequired;
    private Set<String> ignoredJarsSet;
    private Kernel kernel;
    private MBeanServer mbeanServer;
    private CacheFactoryRegistry cacheFactoryRegistry;
    private PoolFactoryRegistry poolFactoryRegistry;
    private RemoteProxyFactoryRegistry remoteProxyFactoryRegistry;
    private PersistenceManagerFactoryRegistry persistenceManagerFactoryRegistry;

    public Ejb3Deployer() {
        this.addInput(JBossMetaData.class);
        this.addInput(PersistenceUnitsMetaData.class);
        this.setOutput(Ejb3Deployment.class);
    }

    @Override
    public void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        this.deploy(unit, unit.getAttachment(JBossMetaData.class), unit.getAttachment(PersistenceUnitsMetaData.class));
    }

    public void deploy(VFSDeploymentUnit unit, JBossMetaData metaData, PersistenceUnitsMetaData persistenceUnitsMetaData) throws DeploymentException {
        try {
            if (metaData != null && (metaData.isEJB2x() || metaData.isEJB1x())) {
                assert (persistenceUnitsMetaData == null) : "Found persistence units in legacy deployment";
                this.log.debug("Ignoring legacy EJB deployment " + unit);
                return;
            }
            VirtualFile jar = unit.getRoot();
            if (jar.isLeaf() || this.ignoredJarsSet.contains(jar.getName())) {
                this.log.trace(this.getClass().getName() + " ignoring: " + jar.getName());
                return;
            }
            if (!this.hasAllowedSuffix(jar.getName())) {
                this.log.trace(this.getClass().getName() + " suffix not allowed: " + jar.getName());
                return;
            }
            if (this.isDeploymentDescriptorRequired() && metaData == null && persistenceUnitsMetaData == null) {
                this.log.trace(this.getClass().getSimpleName() + " skipping deployment \"" + unit.getSimpleName() + "\", jar: \"" + jar.getName() + "\" - either EJB3 Deployment Descriptor or \"jboss.xml\" is required and neither were found.");
                return;
            }
            this.log.debug("********* " + this.getClass().getSimpleName() + " Begin Unit: " + unit.getSimpleName() + " jar: " + jar.getName());
            DeploymentScope scope = null;
            VFSDeploymentUnit parent = unit.getParent();
            if (parent != null && parent.getSimpleName().endsWith(".ear") && (scope = parent.getAttachment(DeploymentScope.class)) == null) {
                scope = new JBoss5DeploymentScope(unit.getParent());
                parent.addAttachment(DeploymentScope.class, scope);
            }
            JBoss5DeploymentUnit du = new JBoss5DeploymentUnit(unit);
            du.setDefaultPersistenceProperties(this.defaultPersistenceProperties);
            Ejb3JBoss5Deployment deployment = new Ejb3JBoss5Deployment(du, this.kernel, this.mbeanServer, unit, scope, metaData, persistenceUnitsMetaData, this);
            if (scope != null) {
                scope.register(deployment);
            }
            deployment.create();
            if (deployment.getEjbContainers().size() == 0 && deployment.getPersistenceUnitDeployments().size() == 0) {
                this.log.trace("Found no containers in scanned jar, consider adding it to the ignore list: " + jar.getName() + " url: " + jar.toURL() + " unit: " + unit.getSimpleName());
                deployment.destroy();
                return;
            }
            unit.addAttachment(Ejb3Deployment.class, deployment);
            unit.addAttachment(JaccPolicyUtil.IGNORE_ME_NAME, true, Boolean.class);
        }
        catch (Throwable t) {
            throw new DeploymentException("Error deploying " + unit.getSimpleName() + ": " + t.getMessage(), t);
        }
    }

    public Set<String> getAllowedSuffixes() {
        return this.allowedSuffixes;
    }

    public CacheFactoryRegistry getCacheFactoryRegistry() {
        return this.cacheFactoryRegistry;
    }

    public void setCacheFactoryRegistry(CacheFactoryRegistry cacheFactoryRegistry) {
        this.cacheFactoryRegistry = cacheFactoryRegistry;
    }

    public PoolFactoryRegistry getPoolFactoryRegistry() {
        return this.poolFactoryRegistry;
    }

    public void setPoolFactoryRegistry(PoolFactoryRegistry poolFactoryRegistry) {
        this.poolFactoryRegistry = poolFactoryRegistry;
    }

    public RemoteProxyFactoryRegistry getRemoteProxyFactoryRegistry() {
        return this.remoteProxyFactoryRegistry;
    }

    public void setRemoteProxyFactoryRegistry(RemoteProxyFactoryRegistry remoteProxyFactoryRegistry) {
        this.remoteProxyFactoryRegistry = remoteProxyFactoryRegistry;
    }

    public PersistenceManagerFactoryRegistry getPersistenceManagerFactoryRegistry() {
        return this.persistenceManagerFactoryRegistry;
    }

    public void setPersistenceManagerFactoryRegistry(PersistenceManagerFactoryRegistry persistenceManagerFactoryRegistry) {
        this.persistenceManagerFactoryRegistry = persistenceManagerFactoryRegistry;
    }

    private boolean hasAllowedSuffix(String name) {
        if (this.allowedSuffixes == null) {
            return true;
        }
        for (String suffix : this.allowedSuffixes) {
            if (!name.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeploymentDescriptorRequired() {
        return this.deploymentDescriptorRequired;
    }

    public void setAllowedSuffixes(Set<String> s) {
        this.allowedSuffixes = s;
    }

    public void setDefaultPersistenceProperties(Properties p) {
        this.defaultPersistenceProperties = p;
    }

    public void setDeploymentDescriptorRequired(boolean b) {
        this.deploymentDescriptorRequired = b;
    }

    public void setIgnoredJarsSet(Set<String> s) {
        this.ignoredJarsSet = s;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setMbeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    @Override
    public void undeploy(VFSDeploymentUnit unit) {
        Ejb3Deployment deployment = unit.getAttachment(Ejb3Deployment.class);
        if (deployment == null) {
            return;
        }
        try {
            deployment.destroy();
        }
        catch (Exception e) {
            this.log.warn("Failed to destroy deployment " + deployment, e);
        }
    }
}

