/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.OptimisticCacheSource;
import org.hibernate.cache.StandardQueryCache;
import org.hibernate.cache.UpdateTimestampsCache;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.ejb3.entity.SecondLevelCacheUtil;

public class OptimisticJBCCache
implements OptimisticCache {
    private static final Log log = LogFactory.getLog(OptimisticJBCCache.class);
    private static final String ITEM = "item";
    private Cache cache;
    private final String regionName;
    private final Fqn regionFqn;
    private OptimisticCacheSource source;
    private boolean localWritesOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptimisticJBCCache(Cache cache, String regionName, String regionPrefix) throws CacheException {
        this.cache = cache;
        this.regionName = regionName;
        this.regionFqn = Fqn.fromString((String)SecondLevelCacheUtil.createRegionFqn(regionName, regionPrefix));
        Configuration config = cache.getConfiguration();
        if (config.isUseRegionBasedMarshalling()) {
            this.localWritesOnly = StandardQueryCache.class.getName().equals(regionName);
            boolean fetchState = config.isFetchInMemoryState();
            try {
                if (this.localWritesOnly) {
                    config.setFetchInMemoryState(false);
                }
                this.activateCacheRegion(this.regionFqn.toString());
            }
            finally {
                if (this.localWritesOnly) {
                    config.setFetchInMemoryState(fetchState);
                }
            }
        } else {
            log.debug((Object)"TreeCache is not configured for region based marshalling");
        }
    }

    public void setSource(OptimisticCacheSource source) {
        this.source = source;
    }

    public void writeInsert(Object key, Object value, Object currentVersion) {
        this.writeUpdate(key, value, currentVersion, null);
    }

    public void writeUpdate(Object key, Object value, Object currentVersion, Object previousVersion) {
        try {
            Option option = new Option();
            DataVersion dv = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(currentVersion, previousVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dv);
            option.setCacheModeLocal(this.localWritesOnly);
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void writeLoad(Object key, Object value, Object currentVersion) {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            option.setCacheModeLocal(this.localWritesOnly);
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.remove(new Fqn(this.regionFqn, new Object[]{key}), (Object)"ITEM");
            option = new Option();
            option.setFailSilently(true);
            DataVersion dv = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(currentVersion, currentVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dv);
            option.setCacheModeLocal(this.localWritesOnly);
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public Object get(Object key) throws CacheException {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            this.cache.getInvocationContext().setOptionOverrides(option);
            return this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public Object read(Object key) throws CacheException {
        try {
            return this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            option.setCacheModeLocal(this.localWritesOnly);
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            log.trace((Object)("performing put() into region [" + this.regionName + "]"));
            Option option = new Option();
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            option.setCacheModeLocal(this.localWritesOnly);
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM, value);
        }
        catch (TimeoutException te) {
            log.debug((Object)"ignoring write lock acquisition failure");
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            if (this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM) != null) {
                Option option = new Option();
                option.setDataVersion(NonLockingDataVersion.INSTANCE);
                option.setCacheModeLocal(this.localWritesOnly);
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.removeNode(new Fqn(this.regionFqn, new Object[]{key}));
            } else {
                log.trace((Object)"skipping remove() call as the underlying node did not seem to exist");
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            option.setCacheModeLocal(this.localWritesOnly);
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.removeNode(this.regionFqn);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            Option option = new Option();
            option.setCacheModeLocal(true);
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.removeNode(this.regionFqn);
            if (this.cache.getConfiguration().isUseRegionBasedMarshalling() && !this.isSharedClassLoaderRegion(this.regionName)) {
                this.inactivateCacheRegion();
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            Set children = this.getChildrenNames();
            return children == null ? 0L : (long)children.size();
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Set childrenNames = this.getChildrenNames();
            if (childrenNames != null) {
                for (Object key : childrenNames) {
                    result.put(key, this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    private Set getChildrenNames() {
        try {
            Node base = this.cache.getRoot().getChild(this.regionFqn);
            return base == null ? null : base.getChildrenNames();
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public String toString() {
        return "OptimisticTreeCache(" + this.regionName + ')';
    }

    private boolean isSharedClassLoaderRegion(String regionName) {
        return StandardQueryCache.class.getName().equals(regionName) || UpdateTimestampsCache.class.getName().equals(regionName);
    }

    private void activateCacheRegion(String regionName) throws CacheException {
        Region region = this.cache.getRegion(this.regionFqn, true);
        if (!region.isActive()) {
            try {
                if (!this.isSharedClassLoaderRegion(regionName)) {
                    region.registerContextClassLoader(Thread.currentThread().getContextClassLoader());
                }
                region.activate();
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
        }
    }

    private void inactivateCacheRegion() throws CacheException {
        Region region = this.cache.getRegion(this.regionFqn, false);
        if (region != null && region.isActive()) {
            try {
                region.deactivate();
                region.unregisterContextClassLoader();
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
        }
    }

    public static class CircumventChecksDataVersion
    implements DataVersion {
        private static final long serialVersionUID = 7996980646166032369L;
        public static final DataVersion INSTANCE = new CircumventChecksDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            throw new CacheException("optimistic locking checks should never happen on CircumventChecksDataVersion");
        }
    }

    public static class NonLockingDataVersion
    implements DataVersion {
        private static final long serialVersionUID = 7050722490368630553L;
        public static final DataVersion INSTANCE = new NonLockingDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            log.trace((Object)"non locking lock check...");
            return false;
        }
    }

    public static class DataVersionAdapter
    implements DataVersion {
        private static final long serialVersionUID = 5564692336076405571L;
        private final Object currentVersion;
        private final Object previousVersion;
        private final Comparator versionComparator;
        private final String sourceIdentifer;

        public DataVersionAdapter(Object currentVersion, Object previousVersion, Comparator versionComparator, String sourceIdentifer) {
            this.currentVersion = currentVersion;
            this.previousVersion = previousVersion;
            this.versionComparator = versionComparator;
            this.sourceIdentifer = sourceIdentifer;
            log.trace((Object)("created " + this));
        }

        public boolean newerThan(DataVersion dataVersion) {
            log.trace((Object)("checking [" + this + "] against [" + dataVersion + "]"));
            if (dataVersion instanceof CircumventChecksDataVersion) {
                log.trace((Object)"skipping lock checks...");
                return false;
            }
            if (dataVersion instanceof NonLockingDataVersion) {
                log.trace((Object)"skipping lock checks...");
                return false;
            }
            DataVersionAdapter other = (DataVersionAdapter)dataVersion;
            if (other.previousVersion == null) {
                log.warn((Object)"Unexpected optimistic lock check on inserting data");
                if (this == dataVersion) {
                    log.trace((Object)"skipping lock checks due to same DV instance");
                    return false;
                }
            }
            if (this.currentVersion == null) {
                return other.previousVersion != null;
            }
            return this.versionComparator.compare(this.currentVersion, other.previousVersion) >= 1;
        }

        public String toString() {
            return super.toString() + " [current=" + this.currentVersion + ", previous=" + this.previousVersion + ", src=" + this.sourceIdentifer + "]";
        }
    }
}

