/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.protocol.jarjar;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;

public class JarJarInputStream
extends InputStream {
    private static final Logger log = Logger.getLogger(JarJarInputStream.class);
    private PipedInputStream pipedInputStream = new PipedInputStream();
    private PipedOutputStream pipedOutputStream = new PipedOutputStream(this.pipedInputStream);
    private Thread writingThread;

    protected JarJarInputStream(final JarFile jarFile, final JarEntry rootEntry) throws IOException {
        Manifest mf = jarFile.getManifest();
        final JarOutputStream jos = mf != null ? new JarOutputStream((OutputStream)this.pipedOutputStream, mf) : new JarOutputStream(this.pipedOutputStream);
        this.writingThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        Object var6_6;
                        JarEntry entry = entries.nextElement();
                        if (!JarJarInputStream.this.isRelativeTo(rootEntry, entry)) continue;
                        InputStream in = jarFile.getInputStream(entry);
                        try {
                            JarEntry newEntry = JarJarInputStream.this.createEntry(rootEntry, entry);
                            jos.putNextEntry(newEntry);
                            JarJarInputStream.this.copy(in, jos, entry.getSize());
                            log.trace("emitted " + newEntry);
                            jos.closeEntry();
                            var6_6 = null;
                        }
                        catch (Throwable throwable) {
                            var6_6 = null;
                            in.close();
                            throw throwable;
                        }
                        in.close();
                        {
                        }
                    }
                    jos.flush();
                    jos.finish();
                }
                catch (IOException e) {
                    log.warn(e.getMessage(), e);
                }
            }
        };
        this.writingThread.start();
    }

    public void close() throws IOException {
        this.pipedOutputStream.close();
        this.pipedInputStream.close();
        super.close();
    }

    protected void copy(InputStream in, OutputStream out, long size) throws IOException {
        byte[] buf = new byte[65536];
        while (size > 0L) {
            int len = in.read(buf);
            if (len < 0) {
                throw new EOFException("Unexpected EOF");
            }
            out.write(buf, 0, len);
            size -= (long)len;
        }
    }

    protected JarEntry createEntry(JarEntry rootEntry, JarEntry template) {
        if (rootEntry == null) {
            return new JarEntry(template);
        }
        String name = template.getName().substring(rootEntry.getName().length());
        JarEntry entry = new JarEntry(name);
        entry.setComment(template.getComment());
        entry.setSize(template.getSize());
        entry.setTime(template.getTime());
        return entry;
    }

    protected boolean isRelativeTo(JarEntry rootEntry, JarEntry current) {
        if (rootEntry == null) {
            return true;
        }
        return current.getName().startsWith(rootEntry.getName()) && !current.getName().equals(rootEntry.getName());
    }

    public int read() throws IOException {
        return this.pipedInputStream.read();
    }
}

