/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.security.CodeSource;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.NullInterceptor;
import org.jboss.ejb3.security.PerClassAspectFactoryAdaptor;
import org.jboss.ejb3.security.RoleBasedAuthorizationInterceptorv2;
import org.jboss.ejb3.security.SecurityDomainManager;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;

public class RoleBasedAuthorizationInterceptorFactory
extends PerClassAspectFactoryAdaptor
implements AspectFactory {
    public Object createPerClass(Advisor advisor) {
        Object domain = null;
        Container container = (Container)((Object)advisor);
        try {
            InitialContext ctx = container.getInitialContext();
            SecurityDomain securityAnnotation = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
            if (securityAnnotation == null) {
                return new NullInterceptor();
            }
            domain = SecurityDomainManager.getSecurityManager(securityAnnotation.value(), ctx);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        AuthenticationManager manager = (AuthenticationManager)domain;
        RealmMapping mapping = (RealmMapping)domain;
        if (manager == null) {
            throw new RuntimeException("Unable to find Security Domain");
        }
        CodeSource ejbCS = advisor.getClazz().getProtectionDomain().getCodeSource();
        String ejbName = ((EJBContainer)advisor).getEjbName();
        return new RoleBasedAuthorizationInterceptorv2(container, ejbCS, ejbName);
    }
}

