/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.remoting;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.jms.exception.MessagingShutdownException;
import org.jboss.jms.wireformat.CallbackRequestSupport;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Util;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class JMSServerInvocationHandler
implements ServerInvocationHandler {
    private static final Logger log = Logger.getLogger(JMSServerInvocationHandler.class);
    private static boolean closed = true;
    private static ReadWriteLock invokeLock;
    private ServerInvoker invoker;
    private MBeanServer server;
    protected Map callbackHandlers = new HashMap();
    private boolean trace = log.isTraceEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClosed(boolean b) {
        try {
            invokeLock.writeLock().acquire();
            try {
                closed = b;
            }
            finally {
                invokeLock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            log.error("Failed to set closed to " + closed, e);
        }
    }

    public JMSServerInvocationHandler() {
        invokeLock = new WriterPreferenceReadWriteLock();
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
        log.debug("set MBeanServer to " + this.server);
    }

    public ServerInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ServerInvoker invoker) {
        this.invoker = invoker;
        log.debug("set ServerInvoker to " + this.invoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationRequest invocation) throws Throwable {
        if (this.trace) {
            log.trace("invoking " + invocation);
        }
        invokeLock.readLock().acquire();
        try {
            if (closed) {
                throw new MessagingShutdownException("Cannot handle invocation since messaging server is not active (it is either starting up or shutting down)");
            }
            RequestSupport request = (RequestSupport)invocation.getParameter();
            if (request instanceof CallbackRequestSupport) {
                this.performCallbackRequest(request);
            }
            ResponseSupport responseSupport = request.serverInvoke();
            return responseSupport;
        }
        finally {
            invokeLock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InvokerCallbackHandler callbackHandler) {
        log.debug("adding callback handler " + callbackHandler);
        if (callbackHandler instanceof ServerInvokerCallbackHandler) {
            ServerInvokerCallbackHandler h = (ServerInvokerCallbackHandler)callbackHandler;
            String sessionId = h.getClientSessionId();
            Map map = this.callbackHandlers;
            synchronized (map) {
                if (this.callbackHandlers.containsKey(sessionId)) {
                    String msg = "The remoting client " + sessionId + " already has a callback handler";
                    log.error(msg);
                    throw new IllegalStateException(msg);
                }
                this.callbackHandlers.put(sessionId, h);
            }
        } else {
            throw new RuntimeException("Do not know how to use callback handler " + callbackHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InvokerCallbackHandler callbackHandler) {
        log.debug("removing callback handler " + callbackHandler);
        Map map = this.callbackHandlers;
        synchronized (map) {
            for (Object key : this.callbackHandlers.keySet()) {
                if (!callbackHandler.equals(this.callbackHandlers.get(key))) continue;
                this.callbackHandlers.remove(key);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getListeners() {
        Map map = this.callbackHandlers;
        synchronized (map) {
            return this.callbackHandlers.values();
        }
    }

    public String toString() {
        return "JMSServerInvocationHandler[" + this.invoker + ", " + this.server + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCallbackRequest(RequestSupport request) {
        CallbackRequestSupport cReq = (CallbackRequestSupport)request;
        String remotingSessionId = cReq.getRemotingSessionID();
        ServerInvokerCallbackHandler callbackHandler = null;
        Map map = this.callbackHandlers;
        synchronized (map) {
            callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.get(remotingSessionId);
        }
        if (callbackHandler == null) {
            throw new IllegalStateException("Cannot find callback handler for session id " + remotingSessionId);
        }
        log.debug("found calllback handler for remoting session " + Util.guidToString(remotingSessionId) + " UID=" + remotingSessionId);
        cReq.setCallbackHandler(callbackHandler);
    }
}

