/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.ChannelFactory;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.GroupListener;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class GroupMember {
    private static final Logger log = Logger.getLogger(GroupMember.class);
    private boolean trace = log.isTraceEnabled();
    private String groupName;
    private long stateTimeout;
    private long castTimeout;
    private ChannelFactory jChannelFactory;
    private Channel controlChannel;
    private Channel dataChannel;
    private RequestTarget requestTarget;
    private GroupListener groupListener;
    private MessageDispatcher dispatcher;
    private volatile View currentView;
    private Object waitLock = new Object();
    private static final int STOPPED = 1;
    private static final int WAITING_FOR_FIRST_VIEW = 2;
    private static final int WAITING_FOR_STATE = 3;
    private static final int STARTED = 4;
    private volatile int startedState;
    private volatile Thread viewThread;

    public GroupMember(String groupName, long stateTimeout, long castTimeout, ChannelFactory jChannelFactory, RequestTarget requestTarget, GroupListener groupListener) {
        this.groupName = groupName;
        this.stateTimeout = stateTimeout;
        this.castTimeout = castTimeout;
        this.jChannelFactory = jChannelFactory;
        this.requestTarget = requestTarget;
        this.groupListener = groupListener;
    }

    public void start() throws Exception {
        this.controlChannel = this.jChannelFactory.createControlChannel();
        this.dataChannel = this.jChannelFactory.createDataChannel();
        this.startedState = 1;
        this.controlChannel.setOpt(3, (Object)Boolean.FALSE);
        this.dataChannel.setOpt(3, (Object)Boolean.FALSE);
        ControlMessageListener messageListener = new ControlMessageListener();
        ControlMembershipListener membershipListener = new ControlMembershipListener();
        ControlRequestHandler requestHandler = new ControlRequestHandler();
        this.dispatcher = new MessageDispatcher(this.controlChannel, (MessageListener)messageListener, (MembershipListener)membershipListener, (RequestHandler)requestHandler, true);
        DataReceiver dataReceiver = new DataReceiver();
        this.dataChannel.setReceiver((Receiver)dataReceiver);
        this.startedState = 2;
        this.controlChannel.connect(this.groupName);
        this.waitForStateChange(3);
        log.debug("First view arrived");
        if (this.controlChannel.getState(null, this.stateTimeout)) {
            this.waitForStateChange(4);
            log.debug("State arrived");
        } else {
            this.startedState = 4;
            log.debug("We are the first member of the group so no need to wait for state");
        }
        this.dataChannel.connect(this.groupName);
    }

    public void stop() throws Exception {
        if (this.startedState == 1) {
            throw new IllegalStateException("Is already stopped");
        }
        try {
            this.dataChannel.close();
        }
        catch (Exception e) {
            log.debug("Failed to close data channel", e);
        }
        try {
            this.controlChannel.close();
        }
        catch (Exception e) {
            log.debug("Failed to close control channel", e);
        }
        this.controlChannel = null;
        this.dataChannel = null;
        this.currentView = null;
        Thread.sleep(1000L);
    }

    public Address getSyncAddress() {
        return this.controlChannel.getLocalAddress();
    }

    public Address getAsyncAddress() {
        return this.dataChannel.getLocalAddress();
    }

    public long getCastTimeout() {
        return this.castTimeout;
    }

    public View getCurrentView() {
        return this.currentView;
    }

    public void multicastControl(ClusterRequest request, boolean sync) throws Exception {
        if (this.startedState == 4) {
            if (this.trace) {
                log.trace(this + " multicasting " + request + " to control channel, sync=" + sync);
            }
            Message message = new Message(null, null, this.writeRequest(request));
            RspList rspList = this.dispatcher.castMessage(null, message, sync ? 2 : 6, this.castTimeout);
            if (sync) {
                for (Rsp rsp : rspList.values()) {
                    if (rsp.wasReceived()) continue;
                    throw new IllegalStateException(this + " response not received from " + rsp.getSender() + " - there may be others");
                }
            }
        }
    }

    public void unicastControl(ClusterRequest request, Address address, boolean sync) throws Exception {
        if (this.startedState == 4) {
            if (this.trace) {
                log.trace(this + " multicasting " + request + " to control channel, sync=" + sync);
            }
            Message message = new Message(address, null, this.writeRequest(request));
            Vector<Address> v = new Vector<Address>();
            v.add(address);
            RspList rspList = this.dispatcher.castMessage(v, message, sync ? 2 : 6, this.castTimeout);
            if (sync) {
                for (Rsp rsp : rspList.values()) {
                    if (rsp.wasReceived()) continue;
                    throw new IllegalStateException(this + " response not received from " + rsp.getSender() + " - there may be others");
                }
            }
        }
    }

    public void multicastData(ClusterRequest request) throws Exception {
        if (this.startedState == 4) {
            if (this.trace) {
                log.trace(this + " multicasting " + request + " to data channel");
            }
            byte[] bytes = this.writeRequest(request);
            this.dataChannel.send(new Message(null, null, bytes));
        }
    }

    public void unicastData(ClusterRequest request, Address address) throws Exception {
        if (this.startedState == 4) {
            if (this.trace) {
                log.trace(this + " unicasting " + request + " to address " + address);
            }
            byte[] bytes = this.writeRequest(request);
            this.dataChannel.send(new Message(address, null, bytes));
        }
    }

    public boolean getState() throws Exception {
        boolean retrievedState = false;
        if (this.controlChannel.getState(null, this.stateTimeout)) {
            this.waitForStateChange(4);
            retrievedState = true;
        } else {
            this.startedState = 4;
        }
        return retrievedState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStateChange(int newState) throws Exception {
        Object object = this.waitLock;
        synchronized (object) {
            long timeRemaining = this.stateTimeout;
            long start = System.currentTimeMillis();
            while (this.startedState != newState && timeRemaining > 0L) {
                this.waitLock.wait(this.stateTimeout);
                if (this.startedState == newState) continue;
                long waited = System.currentTimeMillis() - start;
                timeRemaining -= waited;
            }
            if (this.startedState != newState) {
                throw new IllegalStateException("Timed out waiting for state to change");
            }
        }
    }

    private ClusterRequest readRequest(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dais = new DataInputStream(bais);
        ClusterRequest request = ClusterRequest.createFromStream(dais);
        dais.close();
        return request;
    }

    private byte[] writeRequest(ClusterRequest request) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        DataOutputStream daos = new DataOutputStream(baos);
        ClusterRequest.writeToStream(daos, request);
        daos.flush();
        return baos.toByteArray();
    }

    private class ControlRequestHandler
    implements RequestHandler {
        private ControlRequestHandler() {
        }

        public Object handle(Message message) {
            if (GroupMember.this.trace) {
                log.trace(this + ".RequestHandler received " + message + " on the control channel");
            }
            try {
                if (GroupMember.this.startedState != 4) {
                    throw new IllegalStateException("Received control message but member is not started " + GroupMember.this.startedState);
                }
                byte[] bytes = message.getBuffer();
                ClusterRequest request = GroupMember.this.readRequest(bytes);
                return request.execute(GroupMember.this.requestTarget);
            }
            catch (Throwable e) {
                log.error("Caught Exception in RequestHandler", e);
                IllegalStateException e2 = new IllegalStateException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
        }
    }

    private class DataReceiver
    implements Receiver {
        private DataReceiver() {
        }

        public void block() {
        }

        public void suspect(Address address) {
        }

        public void viewAccepted(View view) {
        }

        public byte[] getState() {
            return null;
        }

        public void receive(Message message) {
            if (GroupMember.this.trace) {
                log.trace(this + " received " + message + " on the data channel");
            }
            try {
                if (GroupMember.this.startedState != 4) {
                    throw new IllegalStateException("Received data message but member is not started " + GroupMember.this.startedState);
                }
                byte[] bytes = message.getBuffer();
                ClusterRequest request = GroupMember.this.readRequest(bytes);
                request.execute(GroupMember.this.requestTarget);
            }
            catch (Throwable e) {
                log.error("Caught Exception in Receiver", e);
                IllegalStateException e2 = new IllegalStateException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
        }

        public void setState(byte[] bytes) {
        }
    }

    private class ControlMembershipListener
    implements MembershipListener {
        private ControlMembershipListener() {
        }

        public void block() {
        }

        public void suspect(Address address) {
        }

        public void viewAccepted(final View newView) {
            log.debug(this + " got new view " + newView + ", old view is " + GroupMember.this.currentView);
            if (GroupMember.this.currentView == null) {
                if (GroupMember.this.startedState != 2) {
                    throw new IllegalStateException("Got first view but started state is " + GroupMember.this.startedState);
                }
            } else if (GroupMember.this.startedState != 4) {
                return;
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ViewChangeRunnable
            implements Runnable {
                ViewChangeRunnable() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    View oldView = GroupMember.this.currentView;
                    GroupMember.this.currentView = newView;
                    try {
                        if (oldView != null) {
                            ArrayList<Address> leftNodes = new ArrayList<Address>();
                            for (Address address : oldView.getMembers()) {
                                if (newView.containsMember(address)) continue;
                                leftNodes.add(address);
                            }
                            if (!leftNodes.isEmpty()) {
                                GroupMember.this.groupListener.nodesLeft(leftNodes);
                            }
                        }
                        for (Address address : newView.getMembers()) {
                            if (oldView != null && oldView.containsMember(address)) continue;
                            GroupMember.this.groupListener.nodeJoined(address);
                        }
                    }
                    catch (Throwable e) {
                        log.error("Caught Exception in MembershipListener", e);
                        IllegalStateException e2 = new IllegalStateException(e.getMessage());
                        e2.setStackTrace(e.getStackTrace());
                        throw e2;
                    }
                    if (GroupMember.this.startedState == 2) {
                        Object object = GroupMember.this.waitLock;
                        synchronized (object) {
                            GroupMember.this.startedState = 3;
                            GroupMember.this.waitLock.notify();
                        }
                    }
                }
            }
            GroupMember.this.viewThread = new Thread(new ViewChangeRunnable());
            GroupMember.this.viewThread.start();
        }

        public byte[] getState() {
            return null;
        }
    }

    private class ControlMessageListener
    implements MessageListener {
        private ControlMessageListener() {
        }

        public byte[] getState() {
            try {
                if (GroupMember.this.startedState != 4) {
                    throw new IllegalStateException("Received control message but group member is not started: " + GroupMember.this.startedState);
                }
                if (GroupMember.this.trace) {
                    log.trace(this + ".ControlMessageListener got state");
                }
                byte[] state = GroupMember.this.groupListener.getState();
                return state;
            }
            catch (Exception e) {
                log.error("Failed to get state", e);
                throw new IllegalStateException("Failed to get state");
            }
        }

        public void receive(Message message) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] bytes) {
            Object object = GroupMember.this.waitLock;
            synchronized (object) {
                if (GroupMember.this.startedState != 3) {
                    throw new IllegalStateException("Received state but started state is " + GroupMember.this.startedState);
                }
                try {
                    GroupMember.this.groupListener.setState(bytes);
                }
                catch (Exception e) {
                    log.error("Failed to set state", e);
                }
                GroupMember.this.startedState = 4;
                GroupMember.this.waitLock.notify();
            }
        }
    }
}

