/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.lang.reflect.UndeclaredThrowableException;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.profileservice.management.AbstractRuntimeComponentDispatcher;

public class KernelBusRuntimeComponentDispatcher
extends AbstractRuntimeComponentDispatcher {
    private KernelBus bus;

    public KernelBusRuntimeComponentDispatcher(KernelBus bus) {
        this(bus, null);
    }

    public KernelBusRuntimeComponentDispatcher(KernelBus bus, MetaValueFactory valueFactory) {
        super(valueFactory);
        if (bus == null) {
            throw new IllegalArgumentException("Null kernel bus.");
        }
        this.bus = bus;
    }

    public MetaValue get(Object componentName, String propertyName) {
        try {
            return this.create(this.bus.get(componentName, propertyName));
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public void set(Object componentName, String propertyName, MetaValue value) {
        try {
            this.bus.set(componentName, propertyName, this.unwrap(value));
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public Object invoke(Object componentName, String methodName, MetaValue ... param) {
        try {
            return this.bus.invoke(componentName, methodName, this.toArguments(param), KernelBusRuntimeComponentDispatcher.toSignature(param));
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }
}

