/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jboss.logging.Logger;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.auth.login.SunConfigParser;
import org.jboss.security.auth.spi.UsersObjectModelFactory;
import org.jboss.security.authorization.config.SecurityConfigObjectModelFactory;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ApplicationPolicyRegistration;
import org.jboss.security.config.PolicyConfig;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class XMLLoginConfigImpl
extends Configuration
implements Serializable,
ApplicationPolicyRegistration {
    private static final long serialVersionUID = -8965860493224188277L;
    private static final String DEFAULT_APP_CONFIG_NAME = "other";
    private static final AuthPermission REFRESH_PERM = new AuthPermission("refreshLoginConfiguration");
    private static Logger log = Logger.getLogger(XMLLoginConfigImpl.class);
    PolicyConfig appConfigs = new PolicyConfig();
    protected URL loginConfigURL;
    protected Configuration parentConfig;
    private boolean validateDTD = true;

    public void refresh() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        if (log.isTraceEnabled()) {
            log.trace("Begin refresh");
        }
        this.appConfigs.clear();
        this.loadConfig();
        if (log.isTraceEnabled()) {
            log.trace("End refresh");
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        BaseAuthenticationInfo bai;
        if (log.isTraceEnabled()) {
            log.trace("Begin getAppConfigurationEntry(" + appName + "), size=" + this.appConfigs.size());
        }
        if (this.appConfigs.size() == 0) {
            this.loadConfig();
        }
        AppConfigurationEntry[] entry = null;
        ApplicationPolicy aPolicy = this.getApplicationPolicy(appName);
        AuthenticationInfo authInfo = null;
        if (aPolicy != null && (bai = aPolicy.getAuthenticationInfo()) instanceof AuthenticationInfo) {
            authInfo = (AuthenticationInfo)bai;
        }
        if (authInfo == null) {
            ApplicationPolicy defPolicy;
            if (log.isTraceEnabled()) {
                log.trace("getAppConfigurationEntry(" + appName + "), no entry in appConfigs, tyring parentCont: " + this.parentConfig);
            }
            if (this.parentConfig != null) {
                entry = this.parentConfig.getAppConfigurationEntry(appName);
            }
            if (entry == null && log.isTraceEnabled()) {
                log.trace("getAppConfigurationEntry(" + appName + "), no entry in parentConfig, trying: " + DEFAULT_APP_CONFIG_NAME);
            }
            AuthenticationInfo authenticationInfo = authInfo = (defPolicy = this.appConfigs.get(DEFAULT_APP_CONFIG_NAME)) != null ? (AuthenticationInfo)defPolicy.getAuthenticationInfo() : null;
        }
        if (authInfo != null) {
            if (log.isTraceEnabled()) {
                log.trace("End getAppConfigurationEntry(" + appName + "), authInfo=" + authInfo);
            }
            final AuthenticationInfo theAuthInfo = authInfo;
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    return theAuthInfo.copyAppConfigurationEntry();
                }
            };
            entry = (AppConfigurationEntry[])AccessController.doPrivileged(action);
        } else if (log.isTraceEnabled()) {
            log.trace("End getAppConfigurationEntry(" + appName + "), failed to find entry");
        }
        return entry;
    }

    public URL getConfigURL() {
        return this.loginConfigURL;
    }

    public void setConfigURL(URL loginConfigURL) {
        this.loginConfigURL = loginConfigURL;
    }

    public void setConfigResource(String resourceName) throws IOException {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        this.loginConfigURL = tcl.getResource(resourceName);
        if (this.loginConfigURL == null) {
            throw new IOException("Failed to find resource: " + resourceName);
        }
    }

    public void setParentConfig(Configuration parentConfig) {
        this.parentConfig = parentConfig;
    }

    public boolean getValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateDTD(boolean flag) {
        this.validateDTD = flag;
    }

    public void addApplicationPolicy(String appName, ApplicationPolicy aPolicy) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        this.appConfigs.add(aPolicy);
        this.handleJASPIDelegation(aPolicy);
        SecurityConfiguration.addApplicationPolicy(aPolicy);
    }

    public void addAppConfig(String appName, AppConfigurationEntry[] entries) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        AuthenticationInfo authInfo = new AuthenticationInfo(appName);
        authInfo.setAppConfigurationEntry(entries);
        if (log.isTraceEnabled()) {
            log.trace("addAppConfig(" + appName + "), authInfo=" + authInfo);
        }
        ApplicationPolicy aPolicy = new ApplicationPolicy(appName, authInfo);
        this.appConfigs.add(aPolicy);
        SecurityConfiguration.addApplicationPolicy(aPolicy);
    }

    public void removeAppConfig(String appName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        if (log.isTraceEnabled()) {
            log.trace("removeAppConfig, appName=" + appName);
        }
        this.appConfigs.remove(appName);
    }

    public ApplicationPolicy getApplicationPolicy(String domainName) {
        ApplicationPolicy aPolicy;
        if (this.appConfigs == null || this.appConfigs.size() == 0) {
            this.loadConfig();
        }
        if ((aPolicy = this.appConfigs.get(domainName)) != null) {
            SecurityConfiguration.addApplicationPolicy(aPolicy);
        }
        return aPolicy;
    }

    public boolean removeApplicationPolicy(String appName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        if (log.isTraceEnabled()) {
            log.trace("removeAppConfig, appName=" + appName);
        }
        this.appConfigs.remove(appName);
        return true;
    }

    public BaseAuthenticationInfo getAuthenticationInfo(String domainName) {
        ApplicationPolicy aPolicy = this.getApplicationPolicy(domainName);
        return aPolicy != null ? aPolicy.getAuthenticationInfo() : null;
    }

    public void clear() {
    }

    public void loadConfig() {
        String loginConfig = System.getProperty("java.security.auth.login.config");
        if (loginConfig == null) {
            loginConfig = "login-config.xml";
        }
        if (this.loginConfigURL == null) {
            try {
                this.loginConfigURL = new URL(loginConfig);
            }
            catch (MalformedURLException e) {
                try {
                    this.setConfigResource(loginConfig);
                }
                catch (IOException ignore) {
                    File configFile = new File(loginConfig);
                    try {
                        this.setConfigURL(configFile.toURL());
                    }
                    catch (MalformedURLException ignore2) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.loginConfigURL == null) {
            log.warn("Failed to find config: " + loginConfig);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Begin loadConfig, loginConfigURL=" + this.loginConfigURL);
        }
        try {
            this.loadConfig(this.loginConfigURL);
            if (log.isTraceEnabled()) {
                log.trace("End loadConfig, loginConfigURL=" + this.loginConfigURL);
            }
        }
        catch (Exception e) {
            log.warn("End loadConfig, failed to load config: " + this.loginConfigURL, e);
        }
    }

    protected String[] loadConfig(URL config) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        ArrayList configNames = new ArrayList();
        log.debug("Try loading config as XML, url=" + config);
        try {
            this.loadXMLConfig(config, configNames);
        }
        catch (Throwable e) {
            log.debug("Failed to load config as XML", e);
            log.debug("Try loading config as Sun format, url=" + config);
            this.loadSunConfig(config, configNames);
        }
        String[] names = new String[configNames.size()];
        configNames.toArray(names);
        return names;
    }

    private void handleJASPIDelegation(ApplicationPolicy aPolicy) {
        BaseAuthenticationInfo bai = aPolicy.getAuthenticationInfo();
        if (bai instanceof JASPIAuthenticationInfo) {
            LoginModuleStackHolder[] lmsharr;
            JASPIAuthenticationInfo jai = (JASPIAuthenticationInfo)bai;
            for (LoginModuleStackHolder lmsh : lmsharr = jai.getLoginModuleStackHolder()) {
                this.addAppConfig(lmsh.getName(), lmsh.getAppConfigurationEntry());
            }
        }
    }

    private void loadSunConfig(URL sunConfig, ArrayList configNames) throws Exception {
        InputStream is = sunConfig.openStream();
        if (is == null) {
            throw new IOException("InputStream is null for: " + sunConfig);
        }
        InputStreamReader configFile = new InputStreamReader(is);
        boolean trace = log.isTraceEnabled();
        SunConfigParser.doParse(configFile, this, trace);
    }

    private void loadXMLConfig(URL loginConfigURL, ArrayList configNames) throws IOException, JBossXBException {
        SecurityConfigObjectModelFactory lcomf = new SecurityConfigObjectModelFactory();
        UsersObjectModelFactory uomf = new UsersObjectModelFactory();
        InputStreamReader xmlReader = this.loadURL(loginConfigURL);
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        unmarshaller.mapFactoryToNamespace(uomf, "http://www.jboss.org/j2ee/schemas/XMLLoginModule");
        Object root = null;
        PolicyConfig config = (PolicyConfig)unmarshaller.unmarshal((Reader)xmlReader, (ObjectModelFactory)lcomf, (Object)root);
        Set cnames = config.getConfigNames();
        configNames.addAll(cnames);
        this.appConfigs.copy(config);
        for (String cname : cnames) {
            ApplicationPolicy ap = config.get(cname);
            SecurityConfiguration.addApplicationPolicy(ap);
            this.handleJASPIDelegation(ap);
        }
    }

    private InputStreamReader loadURL(URL configURL) throws IOException {
        InputStream is = configURL.openStream();
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + configURL);
        }
        InputStreamReader xmlReader = new InputStreamReader(is);
        return xmlReader;
    }
}

